package com.thinkgem.jeesite.modules.pay.api;

import com.thinkgem.jeesite.common.baseBean.Response;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.pay.bean.OrderRequest;
import com.thinkgem.jeesite.modules.pay.entity.OrderEntity;
import com.thinkgem.jeesite.modules.pay.service.OrderService;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.service.DictService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.method.P;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author niehh
 * @Description: 订单相关
 * @date 2018年03月18日 11:04
 */
@RestController
@RequestMapping("/api/order")
public class OrderApiController {

    @Autowired
    private OrderService orderService;

    @Autowired
    private DictService dictService;

    /**
     * 获取订单列表
     * @param request
     * @return
     */
    @PostMapping("/getOrderList")
    public Response getOrderList(OrderRequest request){
        Response res = new Response();
        if(request == null || StringUtils.isBlank(request.getSubMerchantCode())){
            res.setStatus(ComCode.STATUS_CODE_4001);
            res.setMessage(ComCode.STATUS_CODE_4001_DESC);
            return res;
        }

        try {
            System.out.println("开始时间：" + request.getStartDate());
            System.out.println("结束时间：" + request.getEndDate());
            List<OrderEntity> list = orderService.getOrderList(request);

            res.setData(list);
            res.setStatus(ComCode.STATUS_CODE_2000);
            res.setMessage(ComCode.STATUS_CODE_2000_DESC);
        }catch (Exception e){
            res.setMessage(ComCode.STATUS_CODE_9998_DESC);
            res.setStatus(ComCode.STATUS_CODE_9998);
            e.printStackTrace();
        }

        return res;
    }


    /**
     * 获取支付方式
     * @return
     */
    @PostMapping("/getPayMethod")
    public Response getPayMethod(){
        Response response = new Response();

        try {
            Dict dict = new Dict();
            dict.setType("pay_method");
            response.setData(dictService.findDictList(dict));
            response.setStatus(ComCode.STATUS_CODE_2000);
            response.setMessage(ComCode.STATUS_CODE_2000_DESC);
        }catch (Exception e){
            response.setMessage(ComCode.STATUS_CODE_9998_DESC);
            response.setStatus(ComCode.STATUS_CODE_9998);
            e.printStackTrace();
        }

        return response;
    }
}
