package com.thinkgem.jeesite.modules.pay.service;

import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.pay.bean.OrderRequest;
import com.thinkgem.jeesite.modules.pay.dao.OrderApiDao;
import com.thinkgem.jeesite.modules.pay.entity.BenefitEntity;
import com.thinkgem.jeesite.modules.pay.entity.OrderEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * @author niehh
 * @Description: 订单
 * @date 2018年03月18日 10:51
 */
@Service
@Transactional(readOnly = true)
public class OrderService {

    @Autowired
    private OrderApiDao orderApiDao;

    public List<OrderEntity> getOrderList(OrderRequest request){
        if(request.getStartDate()!= null && request.getStartDate() != 0){
            request.setStartTime(DateUtils.formatDate(new Date(request.getStartDate()*1000),"yyyy-MM-dd") + " 00:00:00");
        }
        if(request.getEndDate() != null && request.getEndDate() != 0){
            request.setEndTime(DateUtils.formatDate(new Date(request.getEndDate()*1000),"yyyy-MM-dd") + " 23:59:59");
        }

        return orderApiDao.getOrderList(request);

    }

    public static void main(String[] args){
        Date date = new Date(1522723599416L);
        System.out.println(new Date(1522723775000l));
        System.out.println(System.currentTimeMillis());
    }


}
