package com.thinkgem.jeesite.modules.pay.huanqiuhuiju.service;

import com.alibaba.fastjson.JSONObject;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.constant.ComCode;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.pay.huanqiuhuiju.utils.HttpUtil;
import com.thinkgem.jeesite.modules.pay.huanqiuhuiju.utils.SignUtils;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.Bean2Map;
import com.thinkgem.jeesite.modules.pay.juhezhong.utils.MakeOrderNum;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.SortedMap;

@Transactional
@Service
public class HuanqiuhuijuService {



    public JSONObject huanqiuhuijuPay(JSONObject dto) throws Exception {
        SortedMap map = Bean2Map.JSONObject2SortedMap(dto);
        String sign = SignUtils.createSign(map, ComCode.HUANQIUHUIJU_MERCHANT_KEY);
        map.put("sign",sign);

        String result = HttpUtil.postRequest(ComCode.HUANQIUHUIJU_PAYURL,JSONObject.toJSONString(map));
        System.out.println("result:"+result);
        return JSONObject.parseObject(result);


    }

    public static void main(String[] args) throws Exception {
        HuanqiuhuijuService huanqiuhuijuService = new HuanqiuhuijuService();

        JSONObject dto = new JSONObject();
        String orderId = IdGen.randomBase62(32);
        dto.put("transcode","300");// 交易码
        dto.put("version","0100"); // 版本号
        dto.put("ordersn", MakeOrderNum.makeOrderNum()); // 流水号 每次交易都唯一
        dto.put("merchno",ComCode.HUANQIUHUIJU_MERCHANT_ID); // 商户号
        dto.put("dsorderid", orderId); // 订单号 唯一
        dto.put("txnAmt","1000"); // 交易金额
        dto.put("txnRate","2");// 费率

        dto.put("siglePrice", "100"); // 单笔价格
        dto.put("merchno",ComCode.HUANQIUHUIJU_MERCHANT_ID); // 商户号
        dto.put("realName", "李波"); // 真实姓名
        dto.put("idCardNo","53250219850831031X"); // 身份证号
        dto.put("bankCardNo","6225571645517950");// 银行卡号
        dto.put("bankCode","306331003281"); // 银行代码
        dto.put("bankName","广发银行"); // 消费卡银行名称
        dto.put("phone","13821934497"); // 手机号
        dto.put("cvn2","009");
        dto.put("expireDate","0821");
        dto.put("notifyUrl", Global.getConfig("project.access.url")+"/api/pay/notifyPay");
        dto.put("settleBankCode","102100099996"); // 结算银行代码
        dto.put("settleCardNo","6212260302011080165"); // 结算银行卡
        dto.put("settlePhone","13821934497"); // 结算手机号
        dto.put("settleCardBankName","中国工商银行"); // 结算卡银行名称
        System.out.println(dto.toJSONString());
        huanqiuhuijuService.huanqiuhuijuPay(dto);

        // 20180417101150959000 20180417101211113000 nXXKJE4LI7VV222bgdjrw3013YQ2ozZSMGGmxhZBGqsDeH9OOu6kB0lP3tYjZm4v
    }
}
