/*
 * Decompiled with CFR 0.152.
 */
package com.ckfinder.connector.handlers.command;

import com.ckfinder.connector.configuration.IConfiguration;
import com.ckfinder.connector.errors.ConnectorException;
import com.ckfinder.connector.handlers.command.Command;
import com.ckfinder.connector.utils.FileUtils;
import com.ckfinder.connector.utils.PathUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ErrorCommand
extends Command {
    private ConnectorException e;
    private HttpServletResponse response;

    public void execute(OutputStream out) throws ConnectorException {
        try {
            this.response.setHeader("X-CKFinder-Error", String.valueOf(this.e.getErrorCode()));
            switch (this.e.getErrorCode()) {
                case 102: 
                case 103: 
                case 109: 
                case 501: {
                    this.response.sendError(403);
                    break;
                }
                case 104: {
                    this.response.sendError(500);
                    break;
                }
                default: {
                    this.response.sendError(404);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new ConnectorException(e);
        }
    }

    public void setResponseHeader(HttpServletResponse response, ServletContext sc) {
        response.reset();
        this.response = response;
    }

    public void initParams(HttpServletRequest request, IConfiguration configuration, Object ... params) throws ConnectorException {
        super.initParams(request, configuration, params);
        this.e = (ConnectorException)params[0];
    }

    protected boolean checkParam(String reqParam) throws ConnectorException {
        if (reqParam == null || reqParam.equals("")) {
            return true;
        }
        return !Pattern.compile("(/\\.|\\p{Cntrl}|//|\\\\|[:*?<>\"\\|])").matcher(reqParam).find();
    }

    protected boolean checkHidden() throws ConnectorException {
        if (FileUtils.checkIfDirIsHidden(this.currentFolder, this.configuration)) {
            this.e = new ConnectorException(500);
            return true;
        }
        return false;
    }

    protected boolean checkConnector(HttpServletRequest request) throws ConnectorException {
        if (!this.configuration.enabled() || !this.configuration.checkAuthentication(request)) {
            this.e = new ConnectorException(500);
            return false;
        }
        return true;
    }

    protected boolean checkIfCurrFolderExists(HttpServletRequest request) throws ConnectorException {
        String tmpType = this.getParameter(request, "type");
        File currDir = new File(this.configuration.getTypes().get(tmpType).getPath() + this.currentFolder);
        if (currDir.exists() && currDir.isDirectory()) {
            return true;
        }
        this.e = new ConnectorException(116);
        return false;
    }

    protected void getCurrentFolderParam(HttpServletRequest request) {
        String currFolder = this.getParameter(request, "currentFolder");
        if (currFolder != null && !currFolder.equals("")) {
            this.currentFolder = PathUtils.addSlashToBeginning(PathUtils.addSlashToEnd(currFolder));
        }
    }
}

