package com.thinkgem.jeesite.modules.pay.pinganbank;

import com.alibaba.fastjson.JSONObject;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.pay.pinganbank.dto.PingAnBankDto;
import com.thinkgem.jeesite.modules.pay.pinganbank.util.PingAnBankUtils;
import com.thinkgem.jeesite.modules.pay.pinganbank.util.XmlUtil;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.UnsupportedEncodingException;
import java.util.Date;

@Service
@Transactional
public class PingAnBankService {


    /**
     * 查询余额
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject queryBalance(PingAnBankDto dto) throws Exception {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Account",dto.getAccount());
        jsonObject.put("CcyCode",dto.getCcyCode());
        String body = XmlUtil.JsonBean2XmlString(jsonObject);
        String head = PingAnBankUtils.getHead(body,dto.getEnterprisecode(),"4001",dto.getOrderCode());
        JSONObject json = PingAnBankUtils.post(head+body);

        return json;

    }

    /**
     * 单笔转账
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject singleTransfer(PingAnBankDto dto,JSONObject jsonObject) throws Exception {


        String body = XmlUtil.JsonBean2XmlString(jsonObject);
        String head = PingAnBankUtils.getHead(body,dto.getEnterprisecode(),"4004",dto.getOrderCode());
        JSONObject json = PingAnBankUtils.post(head+body);

        return json;

    }


    /**
     * 查询单笔转账结果
     * @param dto
     * @return
     * @throws Exception
     */
    public JSONObject querySingleTransfer(PingAnBankDto dto,JSONObject jsonObject) throws Exception {


        String body = XmlUtil.JsonBean2XmlString(jsonObject);
        String head = PingAnBankUtils.getHead(body,dto.getEnterprisecode(),"4005",dto.getOrderCode());
        JSONObject json = PingAnBankUtils.post(head+body);

        return json;

    }


    public static void main(String args[]) throws Exception {
//   余额
//        PingAnBankService pingAnBankService = new PingAnBankService();
//        PingAnBankDto dto = new PingAnBankDto();
//        dto.setOrderCode(IdGen.randomBase62(20));
//        dto.setEnterprisecode("00103082100008003000");
//        dto.setCcyCode("RMB");
//        dto.setAccount("11002923034501");
//        pingAnBankService.queryBalance(dto);

//   单笔转账
        PingAnBankService pingAnBankService = new PingAnBankService();
        PingAnBankDto dto = new PingAnBankDto();
        dto.setOrderCode(IdGen.randomBase62(20));
        dto.setEnterprisecode("00103082100008003000");
        JSONObject jsonObject = new JSONObject();
       // <ThirdVoucher>20100811153405</ThirdVoucher>
        // <CcyCode>RMB</CcyCode>
        // <OutAcctNo>11002873403401</OutAcctNo>
        // <OutAcctName>ebt</OutAcctName>
        // <OutAcctAddr>34343</OutAcctAddr>
        // <InAcctBankNode/><InAcctRecCode/>
        // <InAcctNo>11002873390701</InAcctNo>
        // <InAcctName>EBANK</InAcctName>
        // <InAcctBankName>anything</InAcctBankName>
        // <TranAmount>000.01</TranAmount>

        // <UseEx>ZZZZZtestreturn</UseEx>
        // <UnionFlag>1</UnionFlag>
        // <SysFlag>2</SysFlag>
        // <AddrFlag>1</AddrFlag>
        // <RealFlag>2</RealFlag>
        // <MainAcctNo/>

        jsonObject.put("ThirdVoucher","20100811153405"); // 转账凭证号 标示交易唯一性，同一客户上送的不可重复，建议格式：yyyymmddHHSS+8位系列
        jsonObject.put("CcyCode","RMB"); // 货币类型 RMB-人民币
        jsonObject.put("OutAcctNo","11002873403401"); // 付款人账户 扣款账户
        jsonObject.put("OutAcctName","ebt"); // 付款人名称 付款账户户名

        jsonObject.put("OutAcctAddr","34343"); // 付款人地址 建议填写付款账户的分行、网点名称  非必输
        jsonObject.put("OutAcctNo","11002873403401"); // 付款人账户 扣款账户
        jsonObject.put("InAcctBankNode","11002873403401"); // 收款人开户行行号 跨行转账建议必输。为人行登记在册的商业银行号

        jsonObject.put("InAcctNo","11002873390701"); // 收款人账户
        jsonObject.put("InAcctName","EBANK"); // 收款人账户户名

        jsonObject.put("InAcctBankName","anything"); // 收款人开户行名称
        jsonObject.put("TranAmount","000.01"); // 转出金额 如为XML报文，则直接输入输出以元为单位的浮点数值，如2.50 (两元五角)
        jsonObject.put("UseEx","ZZZZZtestreturn"); // 资金用途 30个汉字。现金管理代理结算 非必输
        jsonObject.put("UnionFlag","1"); // 行内跨行标志 1：行内转账，0：跨行转账
        jsonObject.put("SysFlag","2"); // Y：加急 N：普通S：特急默认为N
        jsonObject.put("AddrFlag","1"); // 同城/异地标志 “1”—同城   “2”—异地；若无法区分，可默认送1-同城。


        pingAnBankService.singleTransfer(dto,jsonObject);




        // 查询单笔转账
//        PingAnBankService pingAnBankService = new PingAnBankService();
//        PingAnBankDto dto = new PingAnBankDto();
//        dto.setOrderCode(IdGen.randomBase62(20));
//        dto.setEnterprisecode("00103082100008003000");
//        JSONObject jsonObject = new JSONObject();
//
//
//        jsonObject.put("OrigThirdVoucher","20100811153405"); // 转账凭证号 推荐使用；使用4004接口上送的ThirdVoucher或者4014上送的SThirdVoucher
//
//        pingAnBankService.querySingleTransfer(dto,jsonObject);


//		String url = "http://127.0.0.1:7072/";
//		String xml = "";
//		HttpUtil.postXml(url,xml);
// 00202043000000326000 企业码

//        String res = "A0010102020020204300000032600000000001084001       0120100809171028    2010080981026055                                                                                                          00000                       0<?xml version=\"1.0\" encoding=\"GBK\"?><Result><Account>11002873390701</Account><CcyCode>RMB</CcyCode></Result>";
//       String s = "<?xml version=\"1.0\" encoding=\"GBK\"?><Result><Account>11002923034501</Account><CcyCode>RMB</CcyCode></Result>";
//        System.out.println(s.getBytes("GBK").length+"");
////        String code = "00202043000000326000";
//        String code = "00103082100008003000";
//        String res = "A0010102020010308210000800300000000001084001  123450120120620151810201206180000011037  000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"+s;

//        System.out.println(PingAnBankUtils.getBobyLength("<?xml version=\"1.0\" encoding=\"GB2312\"?><Result><ThirdVoucher>20100811153405</ThirdVoucher><CcyCode>RMB</CcyCode><OutAcctNo>11002873403401</OutAcctNo><OutAcctName>ebt</OutAcctName><OutAcctAddr>34343</OutAcctAddr><InAcctBankNode/><InAcctRecCode/><InAcctNo>11002873390701</InAcctNo><InAcctName>EBANK</InAcctName><InAcctBankName>anything</InAcctBankName><TranAmount>000.01</TranAmount><AmountCode/><UseEx>ZZZZZtestreturn</UseEx><UnionFlag>1</UnionFlag><SysFlag>2</SysFlag><AddrFlag>1</AddrFlag><RealFlag>2</RealFlag><MainAcctNo/></Result>"));
//        String res = "A0010102020010308210000800300000000005344004  123450120120620151810201206180000011037  000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000<?xml version=\"1.0\" encoding=\"GB2312\"?><Result><ThirdVoucher>20100811153405</ThirdVoucher><CcyCode>RMB</CcyCode><OutAcctNo>11002873403401</OutAcctNo><OutAcctName>ebt</OutAcctName><OutAcctAddr>34343</OutAcctAddr><InAcctBankNode/><InAcctRecCode/><InAcctNo>11002873390701</InAcctNo><InAcctName>EBANK</InAcctName><InAcctBankName>anything</InAcctBankName><TranAmount>000.01</TranAmount><AmountCode/><UseEx>ZZZZZtestreturn</UseEx><UnionFlag>1</UnionFlag><SysFlag>2</SysFlag><AddrFlag>1</AddrFlag><RealFlag>2</RealFlag><MainAcctNo/></Result>";
//        PostMethod postMethod = new PostMethod(
//                "http://127.0.0.1:7072");
//
//        postMethod.setRequestEntity(new StringRequestEntity(
//                res, "text/html", "UTF-8"));
//        postMethod.setRequestHeader("Content-Type",
//                "text/xml; charset=UTF-8");
//
//        HttpClient httpClient = new HttpClient();
//        int resultint = httpClient.executeMethod(postMethod);
//        res = new String(postMethod.getResponseBody(),"UTF-8");
//        System.out.println("http response:" + res);
//        postMethod.releaseConnection();
//        System.out.println(resultint);

        System.out.println(new String("浼佷笟鍓嶇疆鏈嶅姟宸插惎鍔?".getBytes("GBK")).toString());

    }




}
