package com.thinkgem.jeesite.modules.user.entity;


import com.fasterxml.jackson.annotation.JsonIgnore;
import com.thinkgem.jeesite.common.baseBean.BaseEntity;

import java.io.Serializable;

public class CardEntity extends BaseEntity implements Serializable {
    @JsonIgnore
    private String userCode; // 用户code
    private String cardType; // 银行卡类型 D储蓄卡 C信用卡
    private String cardNo; // 卡号
    @JsonIgnore
    private String cardMobile; // 预留手机号
    @JsonIgnore
    private String belongBank; // 所属银行
    @JsonIgnore
    private String cardBank; // 开户支行
    @JsonIgnore
    private String cardPlace; // 开户地点
    private String isDebit; // 是否是结算卡 Y是 N否
    private String subMerchantId; // 子商户号
    private String cardSrc; // 图片路径
    @JsonIgnore
    private String type; // 账户类型 1对私 2对公
    private String status; // 卡片审核状态 0未审核 1已审核 2未通过
    private String province; // 省
    private String city; // 市
    @JsonIgnore
    private String delFlag; // 删除标记 0未删除 1已删除

    private String bankName; // 银行名称
    @JsonIgnore
    private String bankShort; // 银行缩写
    private String bankUrl; // 银行logo

    private String supportPayChannel;

    private String swpaccid; // HL2通道 开卡唯一标识

    public CardEntity() {
    }

    public CardEntity(String code) {
        this.setCode(code);
    }

    public CardEntity(String userCode, String isDebit) {
        this.userCode = userCode;
        this.isDebit = isDebit;
    }

    public CardEntity(String code, String userCode, String cardType, String cardNo, String cardMobile, String belongBank, String cardBank, String cardPlace, String isDebit, String subMerchantId, String cardSrc, String type, String status, String province, String city) {
        this.setCode(code);
        this.userCode = userCode;
        this.cardType = cardType;
        this.cardNo = cardNo;
        this.cardMobile = cardMobile;
        this.belongBank = belongBank;
        this.cardBank = cardBank;
        this.cardPlace = cardPlace;
        this.isDebit = isDebit;
        this.delFlag = "0";
        this.subMerchantId = subMerchantId;
        this.cardSrc = cardSrc;
        this.type = type;
        this.status = status;
        this.province = province;
        this.city = city;
        this.setCreatedUser("sys");
        this.setModifiedUser("sys");
    }

    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getCardType() {
        return cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getCardMobile() {
        return cardMobile;
    }

    public void setCardMobile(String cardMobile) {
        this.cardMobile = cardMobile;
    }

    public String getBelongBank() {
        return belongBank;
    }

    public void setBelongBank(String belongBank) {
        this.belongBank = belongBank;
    }

    public String getCardBank() {
        return cardBank;
    }

    public void setCardBank(String cardBank) {
        this.cardBank = cardBank;
    }

    public String getCardPlace() {
        return cardPlace;
    }

    public void setCardPlace(String cardPlace) {
        this.cardPlace = cardPlace;
    }

    public String getIsDebit() {
        return isDebit;
    }

    public void setIsDebit(String isDebit) {
        this.isDebit = isDebit;
    }

    public String getSubMerchantId() {
        return subMerchantId;
    }

    public void setSubMerchantId(String subMerchantId) {
        this.subMerchantId = subMerchantId;
    }

    public String getCardSrc() {
        return cardSrc;
    }

    public void setCardSrc(String cardSrc) {
        this.cardSrc = cardSrc;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(String delFlag) {
        this.delFlag = delFlag;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankShort() {
        return bankShort;
    }

    public void setBankShort(String bankShort) {
        this.bankShort = bankShort;
    }

    public String getBankUrl() {
        return bankUrl;
    }

    public void setBankUrl(String bankUrl) {
        this.bankUrl = bankUrl;
    }

    public String getSupportPayChannel() {
        return supportPayChannel;
    }

    public void setSupportPayChannel(String supportPayChannel) {
        this.supportPayChannel = supportPayChannel;
    }

    public String getSwpaccid() {
        return swpaccid;
    }

    public void setSwpaccid(String swpaccid) {
        this.swpaccid = swpaccid;
    }
}
