package com.thinkgem.jeesite.modules.user.dao;

import com.thinkgem.jeesite.common.baseBean.Request;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.thinkgem.jeesite.modules.pay.entity.RateEntity;
import com.thinkgem.jeesite.modules.user.bean.UserRequest;
import com.thinkgem.jeesite.modules.user.entity.*;

import java.util.List;

@MyBatisDao
public interface UserApiDao {

    UserEntity getUserInfo(Request request);

    void saveIdentifyCode(IdentityCodeEntity identityCodeEntity);

    IdentityCodeEntity getIdentifyCode(UserRequest request);

    UserEntity checkRecommend(UserRequest request);

    UserEntity checkMobile(UserRequest request);

    void signUp(UserEntity userEntity);

    void resetPassword(UserEntity request);

    UserEntity getUserInfoByPassword(UserRequest request);

    UserDetailEntity getUserDetailByCode(UserEntity userEntity);

    CardEntity getCardInfoByCode(UserEntity userEntity);

    CardEntity getDebitCardByUserCode(UserRequest request);

    List<CardEntity> getCardsInfo(UserRequest request);

    CardEntity getCardInfo(Request request);

    void removeCards(UserRequest request);

    void updateCardStatus(CardEntity cardStatusEntity);

    void addNewCard(CardEntity cardEntity);

    void addFeedback(FeedbackEntity feedbackEntity);

    AboutUsEntity getAboutUsInfo(UserRequest request);

    void saveUserDetail(UserDetailEntity userDetailEntity);

    void updateUserDetail(UserDetailEntity userDetailEntity);

    void updateUserInfo(UserEntity userEntity);

    void updateUser(UserRequest userRequest);

    RateEntity getRateByLevel(RateEntity rateEntityParam);

    List<RateEntity> getRateListByLevel(RateEntity rateEntityParam);

    List<UserEntity> getUserInfoBySameRecommend(UserEntity queryUserRecommendEntity);

    UserEntity getUserInfoById(String userId);

    void updateUserLevel(UserEntity recommendedUser);

    List<CardEntity> getRecommendCardsInfo(UserEntity recommendedUser);

    void updateCardNoDebit(UserRequest request);

    void updateCardDebit(UserRequest request);

    CardEntity getDebitCard(CardEntity cardEntity);

    List<ProvinceCityEntity> getProvince(UserRequest request);

    List<ProvinceCityEntity> getCity(UserRequest request);

    List<BelongBankEntity> getBelongBank(UserRequest request);

    BelongBankEntity getBelongBankEntity(UserRequest request);

    Level getLevelByUserLevel(UserRequest request);

    void addUserSubmchid(UserSubMchId userSubMchId);

    UserSubMchId getUserSubmchid(UserSubMchId userSubMchId);

    public int updateUserSubmchid(UserSubMchId userSubMchId);



    public CardEntity getCardByCardNo(CardEntity cardEntity);

    public int addSwpaccid(CardSwpaccidEntity entity);

    public CardSwpaccidEntity getSwpaccid(CardSwpaccidEntity cardSwpaccidEntity);

    CardEntity getCardInfoSwpaccid(Request request);
}
