package com.foc.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.foc.entity.AccessInfo;
import com.foc.entity.SmsResult;
import com.foc.util.HttpClientUtils;
import com.foc.util.PropertiesUtils;
import lombok.extern.log4j.Log4j;

import java.util.Date;
import java.util.Properties;


/**
 * 发送短信
 *
 * @author zangtao
 * @create 2019 - 04 -11 15:35
 */
@Log4j
public class Sms {

    /**
     * 发送短信
     *
     * @param accessInfo 接口公共信息
     * @param mobile     手机号
     * @param msg        短信内容
     * @return
     */
    public static String sendSms(AccessInfo accessInfo, String mobile, String msg) {
        //读取配置文件
        Properties properties = PropertiesUtils.getProperties();
        String smsUrl = properties.getProperty("smsUrl");
        String result;

        result = HttpClientUtils.doGet(smsUrl + "?ai.cp=" + accessInfo.getAicp() + "&ai.cc=" + accessInfo.getAicc()
                    + "&mobile=" + mobile + "&msg=" + msg );
        return result;
    }

}
