package com.bbd.email;

import com.bbd.utils.PropertiesUtil;
import com.opendata.api.ODPRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Properties;

/**
 * 发邮件
 *
 * @author zangtao
 * @create 2019 - 04 -11 16:25
 */
public class Email {

    private static final Logger logger = LoggerFactory.getLogger(Email.class);

    public static String sendEmail(){

        //读取配置文件
        Properties properties = PropertiesUtil.getProperties();
        //接口地址
        String emailUrl = properties.getProperty("emailUrl");

        //接口地址
        String method = properties.getProperty("emailMethod");

        //接口地址
        String Appsecret = properties.getProperty("Appsecret");

        //接口地址
        String AccessToken = properties.getProperty("AccessToken");

        String res = new ODPRequest(emailUrl, Appsecret)
                .addTextSysPara("Method", method)
                .addTextSysPara("AccessToken", AccessToken)
                .addTextSysPara("Format", "json")
                //应用参数
//				   .addTextAppPara("From", "sdhkyxglzx@hnair.com")//邮件服务发件人参数//sdhkyxglzx@hnair.com
//				   .addTextAppPara("To", "zangtao@bbdtek.com")//邮件服务收件人参数
//				   .addTextAppPara("UserName", "sdhkyxglzx")//发件人的内网账号
//				   .addTextAppPara("UserPwd", Coder.getBASE64("075.wxp"))//发件人的密码，需要base64编码
//				   .addTextAppPara("Subject", "邮件标题-测试")//邮件标题
//				   .addTextAppPara("Body", Coder.getBASE64("邮件正文，测试英文字符：You and me are working in the same organization for the same purpose."))//邮件内容参数，需要base64编码
////			.addTextAppPara("Attachments", mapList)//附件
//				   .post();

                .addTextAppPara("StartDate", "2016-11-15")
                .addTextAppPara("EndDate", "2016-11-15").post();

        return res;
    }
}
