package com.foc.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
 * @author lisu
 */
public class DateUtils {
    /**
     * 计算当前日期与{@code endDate}的间隔天数
     *
     * @param time
     * @return 间隔分钟
     */
    public static long until(LocalDateTime time) {
        return Math.abs(LocalDateTime.now().until(time, ChronoUnit.MINUTES));
    }

    public static String getTime(String formatType) {
        SimpleDateFormat format = new SimpleDateFormat(formatType);
        return format.format(System.currentTimeMillis());
    }

    public static String getLastDate() {
        Calendar cal = Calendar.getInstance();
        Date d = cal.getTime();
        SimpleDateFormat sp = new SimpleDateFormat("yyyy-MM-dd");
        String time = sp.format(d);
        return time;
    }

    public static String getTomorrow() {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, 1);
        Date d = cal.getTime();
        SimpleDateFormat sp = new SimpleDateFormat("yyyy-MM-dd");
        String time = sp.format(d);
        return time;
    }

    public static String getTomorrowDate() {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, 1);
        Date d = cal.getTime();
        String time = new SimpleDateFormat("yyyy-MM-dd 00:00:00").format(d);
        return time;
    }

    public static String getAfterTomorrowDate() {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE, 2);
        Date d = cal.getTime();
        String time = new SimpleDateFormat("yyyy-MM-dd 00:00:00").format(d);
        return time;
    }


    public static boolean compareTime(String time1, String time2) {
        SimpleDateFormat sp = new SimpleDateFormat("yyyy-MM-dd");
        Date date1 = null;
        Date date2 = null;
        try {
            date1 = sp.parse(time1);
            date2 = sp.parse(time1);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date1.after(date2);
    }

    /**
     * @return 前天的零点时间
     */
    public static String getTodayStartTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(Calendar.DAY_OF_MONTH, -1);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        String date = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new java.util.Date(calendar.getTime().getTime()));
        return date;
    }

    /**
     * @return 当天的零点时间
     */
    public static String getTodayEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(Calendar.DAY_OF_MONTH, -1);
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        String date = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new java.util.Date(calendar.getTime().getTime()));
        return date;
    }

    public static List<LocalDate> getDatesBetween(LocalDate startDate, LocalDate endDate) {
        long numOfDaysBetween = ChronoUnit.DAYS.between(startDate, endDate);
        return IntStream.iterate(0, i -> i + 1).limit(numOfDaysBetween).mapToObj(i -> startDate.plusDays(i)).collect(Collectors.toList());
    }

    public static void main(String[] args) {
        System.out.println(getTomorrow());
        System.out.println(getAfterTomorrowDate());
    }
}
