package com.foc.dao;

import com.foc.entity.DspReleaseInfo;
import com.foc.entity.Dynamics;
import com.foc.entity.StatisticalEntity;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;
import java.util.List;

/**
 * @author LEGION
 */
public interface StatisticalDao {
    /**
     * 获取所有类型为J，状态为ATA的航线
     *
     * @param date
     * @return
     */
    List<StatisticalEntity> getFlightList(String date);

    /**
     * 根据起飞地和到达地获取航线最近时间
     *
     * @param entity
     * @param acTypes
     * @param date
     * @return
     */
    String getFlightByDepAndArr(@Param(value = "entity") StatisticalEntity entity, @Param(value = "acTypes") List acTypes, @Param(value = "date") String date);

    /**
     * 根据论证机型获取小机型
     *
     * @param verifyAcType
     * @return
     */
    List<String> getLacTypesByVerifyAcType(String verifyAcType);

    /**
     * 根据论证机型获取小机型
     *
     * @param verifyAcTypes
     * @return
     */
    List<String> getLacTypesByVerifyAcTypes(List<String> verifyAcTypes);

    /**
     * 查询航线论证
     *
     * @param entity
     * @param strs
     * @return
     */
    int getVerify(@Param(value = "entity") StatisticalEntity entity, @Param(value = "list") List<String> strs);

    /**
     * 查询开航指令
     *
     * @param entity
     * @param verifyAcType
     * @return
     */
    String getSailingCommand(@Param(value = "entity") StatisticalEntity entity, @Param(value = "verifyAcType") String verifyAcType);

    /**
     * 批量新增或修改
     *
     * @param list
     */
    void insertOrUpdateBatch(List<StatisticalEntity> list);


    /**
     * 获取航班号列表
     *
     * @param date
     * @return
     */
    List<String> getFlightNoList(LocalDate date);

    /**
     * 批量新增或修改
     *
     * @param list
     */
    void insertDspReleaseInfo(List<DspReleaseInfo> list);

    /**
     * 根据日期获取航班动态数据
     *
     * @param date
     * @return
     */
    List<Dynamics> getDynamicsList(String date);

    /**
     * 批量添加航班动态数据
     *
     * @param list
     */
    void addDynamicsList(List<Dynamics> list);

    /**
     * 从备份表查询是否有该航班
     *
     * @param statisticalEntity
     * @return
     */
    String getFromBackUp(StatisticalEntity statisticalEntity);

    /**
     * 根据起飞地和目的地查询航班执行监控信息
     *
     * @param arrIata 到达地
     * @param depIata 起飞地
     * @return
     */
    StatisticalEntity getAirlineStatic(@Param(value = "arrIata") String arrIata, @Param(value = "depIata") String depIata);
}
