package com.foc;

import com.foc.entity.AccessInfo;
import com.foc.service.Sms;
import com.foc.service.SoundMonitorService;
import com.foc.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Properties;

/**
 * @Author: lisu
 * @Date: 2019/4/29 15:35
 * @Description: 安科录音同步任务及数据源监控
 * 1.查看定时任务最后同步时间
 * 2.查看是否有录音文件记录
 * 3.查看安科数据库最后一条数据
 */
public class DbSoundsMonitorTask {

    private static final Logger logger = LoggerFactory.getLogger(DbSoundsMonitorTask.class);

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0){
            loadConf(Thread.currentThread().getContextClassLoader().getResource("global.properties").getPath());
        }else {
            loadConf(args[0]);
        }
    }

    public static void loadConf(String path) throws Exception {
        //查看定时任务最后同步时间
        SoundMonitorService.init();
        Integer i = SoundMonitorService.test();
        if (i == 1){
            //发送短信
            AccessInfo accessInfo = new AccessInfo();
            accessInfo.setAicc("5");
            accessInfo.setAicp("10.68.26.52");
            Properties properties = PropertiesUtil.getProperties(path);
            String result = Sms.sendSms(accessInfo, properties.getProperty("mobile"), "警告");
            logger.info(result);
        }else {
            logger.info("没有异常！" );
        }
    }
}
