/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.Builder;
import org.apache.camel.model.NoOutputExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.RoutingSlip;
import org.apache.camel.spi.RouteContext;

@XmlRootElement(name="routingSlip")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RoutingSlipDefinition<Type extends ProcessorDefinition>
extends NoOutputExpressionNode {
    public static final String DEFAULT_DELIMITER = ",";
    @XmlAttribute
    private String uriDelimiter;
    @XmlAttribute
    private Boolean ignoreInvalidEndpoints;

    public RoutingSlipDefinition() {
        this((String)null, DEFAULT_DELIMITER);
    }

    public RoutingSlipDefinition(String headerName) {
        this(headerName, DEFAULT_DELIMITER);
    }

    public RoutingSlipDefinition(String headerName, String uriDelimiter) {
        super(Builder.header(headerName));
        this.setUriDelimiter(uriDelimiter);
    }

    public RoutingSlipDefinition(Expression expression, String uriDelimiter) {
        super(expression);
        this.setUriDelimiter(uriDelimiter);
    }

    public RoutingSlipDefinition(Expression expression) {
        this(expression, DEFAULT_DELIMITER);
    }

    public String toString() {
        return "RoutingSlip[" + this.getExpression() + "]";
    }

    @Override
    public String getShortName() {
        return "routingSlip";
    }

    @Override
    public String getLabel() {
        return "routingSlip[" + this.getExpression() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Expression expression = this.getExpression().createExpression(routeContext);
        String delimiter = this.getUriDelimiter() != null ? this.getUriDelimiter() : DEFAULT_DELIMITER;
        RoutingSlip routingSlip = new RoutingSlip(routeContext.getCamelContext(), expression, delimiter);
        if (this.getIgnoreInvalidEndpoints() != null) {
            routingSlip.setIgnoreInvalidEndpoints(this.getIgnoreInvalidEndpoints());
        }
        return routingSlip;
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return Collections.emptyList();
    }

    public void setUriDelimiter(String uriDelimiter) {
        this.uriDelimiter = uriDelimiter;
    }

    public String getUriDelimiter() {
        return this.uriDelimiter;
    }

    public void setIgnoreInvalidEndpoints(Boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public Boolean getIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public Type end() {
        return (Type)super.end();
    }

    public RoutingSlipDefinition<Type> ignoreInvalidEndpoints() {
        this.setIgnoreInvalidEndpoints(true);
        return this;
    }

    public RoutingSlipDefinition<Type> uriDelimiter(String uriDelimiter) {
        this.setUriDelimiter(uriDelimiter);
        return this;
    }
}

