package com.foc.dao;

import com.foc.entity.FocSmsEmailRecord;
import com.foc.entity.SoundInfo;
import com.foc.entity.SoundsMaxId;
import org.apache.ibatis.annotations.Param;
import java.util.List;

/**
 * @Author: lisu
 * @Date: 2019/4/29 16:23
 * @Description: java类作用描述
 */
public interface SoundsMaxIdDao {

    /**
     * 获取最后更新记录
     *
     * @return
     */
    SoundsMaxId getMaxId();

    /**
     * 获取信息
     *
     * @param date
     * @return
     */
    List<SoundInfo> getInfo(@Param("date") String date);

    /**
     * 新增巡检记录
     *
     * @param focSmsEmailRecord
     */
    void insertFocRecord(FocSmsEmailRecord focSmsEmailRecord);

    /**
     * 已经发送过短信
     *
     * @return
     */
    FocSmsEmailRecord selectFocSendSmsRecord();

    /**
     * 已经发送过邮件
     *
     * @return
     */
    FocSmsEmailRecord selectFocSendEmailRecord();

    /**
     * 根据创建时间获取最新的一条数据
     *
     * @return
     */
    FocSmsEmailRecord selectLatestOne();

    /**
     * 更新短信状态
     *
     * @param focSmsEmailRecord
     */
    void updateSms(FocSmsEmailRecord focSmsEmailRecord);

    /**
     * 更新邮件状态
     *
     * @param focSmsEmailRecord
     */
    void updateEmail(FocSmsEmailRecord focSmsEmailRecord);

    /**
     * 查询IP锁列表
     *
     * @return
     */
    List<String> getBlackIpList();

    /**
     * 删除ip锁
     *
     * @param blackIp
     */
    void deleteBlackIp(@Param("blackIp") String blackIp);

    /**
     * 根据时间查询通话记录
     *
     * @param updateTime
     * @return
     */
    SoundInfo getInfoByUpdateTime(@Param("updateTime") String updateTime);
}
