/*
 * Decompiled with CFR 0.152.
 */
package com.opendata.api.util;

import com.opendata.api.FileItem;
import com.opendata.api.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;

public class ODPUtils {
    public static String signRequest(Map<String, String> params, String secret) throws IOException {
        TreeSet<String> keys = new TreeSet<String>();
        for (String k : params.keySet()) {
            String v = params.get(k);
            if (v instanceof FileItem) continue;
            keys.add(k);
        }
        StringBuilder query = new StringBuilder();
        query.append(secret);
        for (String key : keys) {
            if (key.equals("Sign")) continue;
            String value = String.valueOf(params.get(key));
            if (!StringUtils.areNotEmpty(key, value)) continue;
            query.append(key).append(value);
        }
        query.append(secret);
        byte[] bytes = ODPUtils.encryptMD5(query.toString());
        return ODPUtils.byte2hex(bytes);
    }

    private static String getStringFromException(Throwable e) {
        String result = "";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        e.printStackTrace(ps);
        try {
            result = bos.toString("UTF-8");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static byte[] encryptMD5(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data.getBytes("UTF-8"));
        }
        catch (GeneralSecurityException gse) {
            String msg = ODPUtils.getStringFromException(gse);
            throw new IOException(msg);
        }
        return bytes;
    }

    public static byte[] encryptSHA(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            bytes = md.digest(data.getBytes("UTF-8"));
        }
        catch (GeneralSecurityException gse) {
            String msg = ODPUtils.getStringFromException(gse);
            throw new IOException(msg);
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
            ++i;
        }
        return sign.toString();
    }

    public static String getFileSuffix(byte[] bytes) {
        if (bytes == null || bytes.length < 10) {
            return null;
        }
        if (bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70) {
            return "GIF";
        }
        if (bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71) {
            return "PNG";
        }
        if (bytes[6] == 74 && bytes[7] == 70 && bytes[8] == 73 && bytes[9] == 70) {
            return "JPG";
        }
        if (bytes[0] == 66 && bytes[1] == 77) {
            return "BMP";
        }
        return null;
    }

    public static String getMimeType(byte[] bytes) {
        String suffix = ODPUtils.getFileSuffix(bytes);
        String mimeType = "JPG".equals(suffix) ? "image/jpeg" : ("GIF".equals(suffix) ? "image/gif" : ("PNG".equals(suffix) ? "image/png" : ("BMP".equals(suffix) ? "image/bmp" : "application/octet-stream")));
        return mimeType;
    }

    public static synchronized String genRandomNum(int pwd_len) {
        int maxNum = 36;
        int count = 0;
        char[] str = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        StringBuffer pwd = new StringBuffer("");
        Random r = new Random();
        while (count < pwd_len) {
            int i = Math.abs(r.nextInt(36));
            if (i < 0 || i >= str.length) continue;
            pwd.append(str[i]);
            ++count;
        }
        return pwd.toString();
    }

    public static String generateAppsecret(String appId) throws IOException {
        String dateTime = String.valueOf(new Date().getTime());
        byte[] b = null;
        b = ODPUtils.encryptMD5(String.valueOf(appId) + dateTime);
        return ODPUtils.byte2hex(b);
    }

    public static String generateRandomAppsecret() throws IOException {
        String str = ODPUtils.genRandomNum(32);
        return str;
    }

    public static String generateAccessToken(String appsecret) throws IOException {
        byte[] b = null;
        String dateTime = String.valueOf(new Date().getTime());
        b = ODPUtils.encryptSHA(String.valueOf(appsecret) + dateTime);
        return ODPUtils.byte2hex(b);
    }
}

