package com.foc;

import com.foc.service.DspReleaseInfoService;
import com.foc.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

/**
 * @author LEGION
 */
public class DspReleaseInfoTask {
    private static final Logger log = LoggerFactory.getLogger(DspReleaseInfoTask.class);

    public static void main(String[] args) throws Exception {
        DspReleaseInfoService.init();
        List<LocalDate> dates = new ArrayList<>();
        //如果参数不为空，开始按照输入时间进行统计
        if (args.length != 0) {
            log.info("input beginTime：" + args[0] + "，input endTime：" + args[1]);
            //获取开始时间到结束时间所有日期
            LocalDate startDate = LocalDate.parse(args[0], DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            LocalDate endDate = LocalDate.parse(args[1], DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            //如果开始时间晚于结束时间，退出
            if (startDate.isAfter(endDate)) {
                log.info("error:input wrongTime");
                return;
            }
            //如果两个时间相同，退出
            dates = DateUtils.getDatesBetween(startDate, endDate);
            if (CollectionUtils.isEmpty(dates)) {
                log.info("error:no static time");
                return;
            }
        } else {
            //按照当天数据开始统计
            dates.add(LocalDate.now());
        }
        DspReleaseInfoService.addInfo(dates);
        for (int i = 1; i <=2 ; i++) {
            DspReleaseInfoService.addPltPlan(LocalDate.now().plusDays(-i));
        }
//        DspReleaseInfoService.addPltPlan(LocalDate.parse("2023-07-22", DateTimeFormatter.ofPattern("yyyy-MM-dd")));
    }
}
