package com.foc;

import com.foc.service.SoundMonitorService;
import com.foc.util.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Properties;

/**
 * @Author: lisu
 * @Date: 2019/4/29 15:35
 * @Description: 安科录音同步任务及数据源监控
 * 1.查看定时任务最后同步时间
 * 2.查看是否有录音文件记录
 * 3.查看安科数据库最后一条数据
 */

public class DbSoundsMonitorTask {

    private static final Logger log = LoggerFactory.getLogger(DbSoundsMonitorTask.class);

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0){
            //本地启动是可以。到了服务器变成了java.io.FileNotFoundException: file:/data/smsAndEmailTest/task-3.0-SNAPSHOT.jar!/global.properties (No such file or directory)
            //loadConf(Thread.currentThread().getContextClassLoader().getResource("global.properties").getPath());
            Properties properties = PropertiesUtils.getProperties();
            load(properties);
        }else {
            loadConf(args[0]);
        }
    }

    public static void loadConf(String path) throws Exception {
        Properties properties = PropertiesUtils.getProperties(path);
        load(properties);
    }

    public static void load(Properties properties){
        String aicc = properties.getProperty("aicc");
        String aicp = properties.getProperty("aicp");
        String resultCode = properties.getProperty("resultCode");
        String mobile = properties.getProperty("mobile");
        //查看定时任务最后同步时间
        SoundMonitorService.init();
        boolean i = SoundMonitorService.test();
        if (!i){
            log.info("没有异常!");
            return;
        }
        //发送邮件和短信
        SoundMonitorService.sendEmailAndSms(aicc,aicp,resultCode,mobile);
    }
}

