package com.foc.service;

import com.foc.util.Coder;
import com.foc.util.PropertiesUtil;
import com.opendata.api.ODPRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.*;

/**
 * 发邮件
 *
 * @author zangtao
 * @create 2019 - 04 -11 16:25
 */
public class Email {

    private static final Logger logger = LoggerFactory.getLogger(Email.class);

    //正式环境服务接口请用调用地址 http://esb.hna.net/api
    //测试环境服务接口请用调用地址  http://10.70.72.110/api/inner/ESBService
    //API服务接口请求调用地址，查看说明文档
    /**
     * URL:              API服务接口请求调用地址，查看说明文档
     * method:           API接口名称，查看个人订单-接口名称
     * Appsecret:        app密钥，查看个人中心-app key
     * AccessToken:      应用票据，查看个人中心-app key
     */
    String URL = "http://10.70.72.110/api/inner/ESBService";
    String method = "Exchange_MailService_SendMail";
    String Appsecret = "9eztwb08qdvkzk0zadzdvtl6j1bssqvp";
    String AccessToken = "A6BD747ECB212285E6DC3528EFB482AF04B40F17";

    /**
     * 发送邮件
     *
     * @param toEmail 收件人邮箱
     * @param subject 主题
     * @param body 正文
     * @return
     */
    public static String sendEmail(String toEmail , String subject , String body ){

        //读取配置文件
        Properties properties = PropertiesUtil.getProperties();
        //接口地址
        String emailUrl = properties.getProperty("emailUrl");

        //接口地址
        String method = properties.getProperty("emailMethod");

        //接口地址
        String Appsecret = properties.getProperty("Appsecret");

        //接口地址
        String AccessToken = properties.getProperty("AccessToken");

        //邮件服务发件人参数
        String fromEmail = properties.getProperty("fromEmail");

        //发件人的内网账号
        String UserName = properties.getProperty("UserName");

        //发件人的密码
        String UserPwd = properties.getProperty("UserPwd");

        String res = new ODPRequest(emailUrl, Appsecret)
                .addTextSysPara("Method", method)
                .addTextSysPara("AccessToken", AccessToken)
                .addTextSysPara("Format", "json")
                //应用参数
                //邮件服务发件人参数//sdhkyxglzx@hnair.com
				   .addTextAppPara("From", fromEmail)
                //邮件服务收件人参数
				   .addTextAppPara("To", toEmail)
                //发件人的内网账号
				   .addTextAppPara("UserName", UserName)
                //发件人的密码，需要base64编码
				   .addTextAppPara("UserPwd", Coder.getBASE64(UserPwd))
                //邮件标题
				   .addTextAppPara("Subject",subject)

                //邮件内容参数，需要base64编码
				   .addTextAppPara("Body", Coder.getBASE64(body))
//			.addTextAppPara("Attachments", mapList)//附件
				   .post();

//                .addTextAppPara("StartDate", "2016-11-15")
//                .addTextAppPara("EndDate", "2016-11-15").post();

        return res;
    }


    public void testEmail() throws Exception {

        //拼装附件mapList
        List<Object> mapList = new ArrayList<Object>();
        Map<String, String> map = new HashMap<String, String>();
        Map<String, Object> mapAttachment = new HashMap<String, Object>();
        Map<String, Object> mapAttachment2 = new HashMap<String, Object>();
        map.put("FileName", "附件1.txt");//文件名称
        map.put("Content", Coder.getBASE64("这是附件1的内容."));//文件内容：需要字节流的base64编码值
        mapAttachment.put("Attachment", map);
        mapList.add(mapAttachment);
        Map<String, String> map2 = new HashMap<String, String>();
        map2.put("FileName", "IMG_2005.PNG");
        map2.put("Content", Coder.fileCode("E:" + File.separator + "IMG_2005.PNG"));
        mapAttachment2.put("Attachment", map2);
        mapList.add(mapAttachment2);

        String res = new ODPRequest(URL, Appsecret)
                .addTextSysPara("Method", method)
                .addTextSysPara("AccessToken", AccessToken)
                .addTextSysPara("Format", "json")
                //应用参数
                .addTextAppPara("From", "sdhkyxglzx@hnair.com")//邮件服务发件人参数//sdhkyxglzx@hnair.com
                .addTextAppPara("To", "chl.zhou@hnair.com")//邮件服务收件人参数
                .addTextAppPara("UserName", "sdhkyxglzx")//发件人的内网账号
                .addTextAppPara("UserPwd", Coder.getBASE64("075.wxp"))//发件人的密码，需要base64编码
                .addTextAppPara("Subject", "邮件标题-测试")//邮件标题
                .addTextAppPara("Body", Coder.getBASE64("邮件正文，测试英文字符：You and me are working in the same organization for the same purpose."))//邮件内容参数，需要base64编码
//			.addTextAppPara("Attachments", mapList)//附件
                .post();

        System.out.println(res);
    }
}
