/*
 * Decompiled with CFR 0.152.
 */
package com.opendata.api;

import com.opendata.api.NormalRequest;
import com.opendata.api.util.JsonDataUtils;
import com.opendata.api.util.ODPUtils;
import com.opendata.api.util.StringUtils;
import com.opendata.api.util.WebCUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ODPRequest
extends NormalRequest {
    private String appSecret;

    public ODPRequest(String url, String appSecret) {
        super(url);
        this.appSecret = appSecret;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    private String addSign() throws IOException {
        if (this.textMap.get("Method") == null) {
            return this.errorMsg("Method\u4e0d\u5f97\u4e3a\u7a7a!", "");
        }
        if (this.textMap.get("Timestamp") == null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timestamp = df.format(new Date());
            this.textMap.put("Timestamp", timestamp);
        }
        this.textMap.put("Sign", ODPUtils.signRequest(this.textMap, this.appSecret));
        return null;
    }

    @Override
    public String post() {
        String res = "";
        try {
            if (StringUtils.areNotEmpty(this.textMapJson)) {
                this.textMap.put("Parameter", this.textMapJson);
            } else {
                this.textMap.put("Parameter", JsonDataUtils.toJson(this.parameterMap));
            }
            String signResult = this.addSign();
            if (signResult != null) {
                return signResult;
            }
            res = WebCUtils.doPost(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            res = this.errorMsg(e.toString(), "");
        }
        return res;
    }

    @Override
    public byte[] postAsByte() {
        byte[] res = null;
        try {
            String signResult = this.addSign();
            if (signResult != null) {
                return signResult.getBytes("utf-8");
            }
            res = WebCUtils.doPostAsByte(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                res = this.errorMsg(e.toString(), "").getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
        }
        return res;
    }

    @Override
    public String get() {
        String res = "";
        try {
            if (StringUtils.areNotEmpty(this.textMapJson)) {
                this.textMap.put("Parameter", this.textMapJson);
            } else {
                this.textMap.put("Parameter", JsonDataUtils.toJson(this.parameterMap));
            }
            String signResult = this.addSign();
            if (signResult != null) {
                return signResult;
            }
            res = WebCUtils.doGet(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            res = this.errorMsg(e.toString(), "");
        }
        return res;
    }

    @Override
    public byte[] getAsByte() {
        byte[] res = null;
        try {
            String signResult = this.addSign();
            if (signResult != null) {
                return signResult.getBytes("utf-8");
            }
            res = WebCUtils.doGetAsByte(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                res = this.errorMsg(e.toString(), "").getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
        }
        return res;
    }

    private String errorMsg(String msg, String erorrCode) {
        String str = null;
        str = "json".equals(this.textMap.get("Format")) ? "{ MsgResponse : {ResponseInfo: {Result:\"-1\",ErrorCode: \"" + erorrCode + "\" ," + "ErrorInfo" + ":\" " + msg + "\" ," + "Data" + ":{}" + "}, " + "Data:{ } " + "} " + "} " : "<?xml version=\"1.0\" encoding=\"UTF-8\"?><MsgResponse><ResponseInfo><Result>-1</Result><ErrorCode>" + erorrCode + "</ " + "ErrorCode" + " >" + "<" + "ErrorInfo" + ">" + msg + "</" + "ErrorInfo" + ">" + "</ResponseInfo>" + "<Data></Data>" + "</MsgResponse>";
        return str;
    }

    public static void main(String[] adfas) throws Exception {
    }
}

