package com.bbd.email;

import com.bbd.utils.Coder;
import com.bbd.utils.PropertiesUtil;
import com.opendata.api.ODPRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Properties;

/**
 * 发邮件
 *
 * @author zangtao
 * @create 2019 - 04 -11 16:25
 */
public class Email {

    private static final Logger logger = LoggerFactory.getLogger(Email.class);

    /**
     * 发送邮件
     *
     * @param toEmail 收件人邮箱
     * @param subject 主题
     * @param body 正文
     * @return
     */
    public static String sendEmail(String toEmail , String subject , String body ){

        //读取配置文件
        Properties properties = PropertiesUtil.getProperties();
        //接口地址
        String emailUrl = properties.getProperty("emailUrl");

        //接口地址
        String method = properties.getProperty("emailMethod");

        //接口地址
        String Appsecret = properties.getProperty("Appsecret");

        //接口地址
        String AccessToken = properties.getProperty("AccessToken");

        //邮件服务发件人参数
        String fromEmail = properties.getProperty("fromEmail");

        //发件人的内网账号
        String UserName = properties.getProperty("UserName");

        //发件人的密码
        String UserPwd = properties.getProperty("UserPwd");

        String res = new ODPRequest(emailUrl, Appsecret)
                .addTextSysPara("Method", method)
                .addTextSysPara("AccessToken", AccessToken)
                .addTextSysPara("Format", "json")
                //应用参数
                //邮件服务发件人参数//sdhkyxglzx@hnair.com
				   .addTextAppPara("From", fromEmail)
                //邮件服务收件人参数
				   .addTextAppPara("To", toEmail)
                //发件人的内网账号
				   .addTextAppPara("UserName", UserName)
                //发件人的密码，需要base64编码
				   .addTextAppPara("UserPwd", Coder.getBASE64(UserPwd))
                //邮件标题
				   .addTextAppPara("Subject",subject)

                //邮件内容参数，需要base64编码
				   .addTextAppPara("Body", Coder.getBASE64(body))
//			.addTextAppPara("Attachments", mapList)//附件
				   .post();

//                .addTextAppPara("StartDate", "2016-11-15")
//                .addTextAppPara("EndDate", "2016-11-15").post();

        return res;
    }
}
