/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public final class IOConverter {
    private static final transient Logger LOG = LoggerFactory.getLogger(IOConverter.class);

    private IOConverter() {
    }

    @Converter
    public static InputStream toInputStream(URL url) throws IOException {
        return IOHelper.buffered(url.openStream());
    }

    @Converter
    public static InputStream toInputStream(File file) throws IOException {
        return IOHelper.buffered(new FileInputStream(file));
    }

    @Deprecated
    public static BufferedReader toReader(File file) throws IOException {
        return IOConverter.toReader(file, null);
    }

    @Converter
    public static BufferedReader toReader(File file, Exchange exchange) throws IOException {
        return IOHelper.buffered(new EncodingFileReader(file, IOHelper.getCharsetName(exchange)));
    }

    @Converter
    public static File toFile(String name) throws FileNotFoundException {
        return new File(name);
    }

    @Converter
    public static OutputStream toOutputStream(File file) throws FileNotFoundException {
        return IOHelper.buffered(new FileOutputStream(file));
    }

    @Deprecated
    public static BufferedWriter toWriter(File file) throws IOException {
        return IOConverter.toWriter(file, null);
    }

    @Converter
    public static BufferedWriter toWriter(File file, Exchange exchange) throws IOException {
        return IOHelper.buffered(new EncodingFileWriter(file, IOHelper.getCharsetName(exchange)));
    }

    @Deprecated
    public static Reader toReader(InputStream in) throws IOException {
        return IOConverter.toReader(in, null);
    }

    @Converter
    public static Reader toReader(InputStream in, Exchange exchange) throws IOException {
        return IOHelper.buffered(new InputStreamReader(in, IOHelper.getCharsetName(exchange)));
    }

    @Deprecated
    public static Writer toWriter(OutputStream out) throws IOException {
        return IOConverter.toWriter(out, null);
    }

    @Converter
    public static Writer toWriter(OutputStream out, Exchange exchange) throws IOException {
        return IOHelper.buffered(new OutputStreamWriter(out, IOHelper.getCharsetName(exchange)));
    }

    @Converter
    public static StringReader toReader(String text) {
        return new StringReader(text);
    }

    @Deprecated
    public static InputStream toInputStream(String text) throws IOException {
        return IOConverter.toInputStream(text, null);
    }

    @Converter
    public static InputStream toInputStream(String text, Exchange exchange) throws IOException {
        return IOConverter.toInputStream(text.getBytes(IOHelper.getCharsetName(exchange)));
    }

    @Converter
    public static InputStream toInputStream(StringBuffer buffer, Exchange exchange) throws IOException {
        return IOConverter.toInputStream(buffer.toString(), exchange);
    }

    @Converter
    public static InputStream toInputStream(StringBuilder builder, Exchange exchange) throws IOException {
        return IOConverter.toInputStream(builder.toString(), exchange);
    }

    @Deprecated
    public static InputStream toInputStream(BufferedReader buffer) throws IOException {
        return IOConverter.toInputStream(buffer, null);
    }

    @Converter
    public static InputStream toInputStream(BufferedReader buffer, Exchange exchange) throws IOException {
        return IOConverter.toInputStream(IOConverter.toString(buffer), exchange);
    }

    @Deprecated
    public static String toString(byte[] data) throws IOException {
        return IOConverter.toString(data, null);
    }

    @Converter
    public static String toString(byte[] data, Exchange exchange) throws IOException {
        return new String(data, IOHelper.getCharsetName(exchange));
    }

    @Deprecated
    public static String toString(File file) throws IOException {
        return IOConverter.toString(file, null);
    }

    @Converter
    public static String toString(File file, Exchange exchange) throws IOException {
        return IOConverter.toString(IOConverter.toReader(file, exchange));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static byte[] toByteArray(File file) throws IOException {
        InputStream is = IOConverter.toInputStream(file);
        try {
            byte[] byArray = IOConverter.toBytes(is);
            return byArray;
        }
        finally {
            IOHelper.close(is, "file", LOG);
        }
    }

    @Deprecated
    public static byte[] toByteArray(Reader reader) throws IOException {
        return IOConverter.toByteArray(reader, null);
    }

    @Converter
    public static byte[] toByteArray(Reader reader, Exchange exchange) throws IOException {
        return IOConverter.toByteArray(IOHelper.buffered(reader), exchange);
    }

    @Deprecated
    public static String toString(URL url) throws IOException {
        return IOConverter.toString(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static String toString(URL url, Exchange exchange) throws IOException {
        InputStream is = IOConverter.toInputStream(url);
        try {
            String string = IOConverter.toString(is, exchange);
            return string;
        }
        finally {
            IOHelper.close(is, "url", LOG);
        }
    }

    @Converter
    public static String toString(Reader reader) throws IOException {
        return IOConverter.toString(IOHelper.buffered(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static String toString(BufferedReader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(1024);
        char[] buf = new char[1024];
        try {
            int len;
            while ((len = reader.read(buf)) != -1) {
                sb.append(buf, 0, len);
            }
        }
        finally {
            IOHelper.close(reader, "reader", LOG);
        }
        return sb.toString();
    }

    @Deprecated
    public static byte[] toByteArray(BufferedReader reader) throws IOException {
        return IOConverter.toByteArray(reader, null);
    }

    @Converter
    public static byte[] toByteArray(BufferedReader reader, Exchange exchange) throws IOException {
        return IOConverter.toByteArray(IOConverter.toString(reader), exchange);
    }

    @Deprecated
    public static byte[] toByteArray(String value) throws IOException {
        return IOConverter.toByteArray(value, null);
    }

    @Converter
    public static byte[] toByteArray(String value, Exchange exchange) throws IOException {
        return value != null ? value.getBytes(IOHelper.getCharsetName(exchange)) : null;
    }

    @Deprecated
    public static String toString(InputStream in) throws IOException {
        return IOConverter.toString(in, null);
    }

    @Converter
    public static String toString(InputStream in, Exchange exchange) throws IOException {
        return IOConverter.toString(IOConverter.toReader(in, exchange));
    }

    @Converter
    public static InputStream toInputStream(byte[] data) {
        return new ByteArrayInputStream(data);
    }

    @Converter
    public static ObjectOutput toObjectOutput(OutputStream stream) throws IOException {
        if (stream instanceof ObjectOutput) {
            return (ObjectOutput)((Object)stream);
        }
        return new ObjectOutputStream(IOHelper.buffered(stream));
    }

    @Converter
    public static ObjectInput toObjectInput(InputStream stream, final Exchange exchange) throws IOException {
        if (stream instanceof ObjectInput) {
            return (ObjectInput)((Object)stream);
        }
        return new ObjectInputStream(IOHelper.buffered(stream)){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                Class<?> answer = null;
                String name = objectStreamClass.getName();
                if (exchange != null) {
                    LOG.trace("Loading class {} using Camel ClassResolver", (Object)name);
                    answer = exchange.getContext().getClassResolver().resolveClass(name);
                }
                if (answer == null) {
                    LOG.trace("Loading class {} using JDK default implementation", (Object)name);
                    answer = super.resolveClass(objectStreamClass);
                }
                return answer;
            }
        };
    }

    @Converter
    public static byte[] toBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOHelper.copy(IOHelper.buffered(stream), bos);
        return bos.toByteArray();
    }

    @Converter
    public static byte[] toByteArray(ByteArrayOutputStream os) {
        return os.toByteArray();
    }

    @Deprecated
    public static String toString(ByteArrayOutputStream os) throws IOException {
        return IOConverter.toString(os, null);
    }

    @Converter
    public static String toString(ByteArrayOutputStream os, Exchange exchange) throws IOException {
        return os.toString(IOHelper.getCharsetName(exchange));
    }

    @Converter
    public static InputStream toInputStream(ByteArrayOutputStream os) {
        return new ByteArrayInputStream(os.toByteArray());
    }

    @Deprecated
    public static String getCharsetName(Exchange exchange, boolean useDefault) {
        return IOHelper.getCharsetName(exchange, useDefault);
    }

    @Deprecated
    public static String getCharsetName(Exchange exchange) {
        return IOConverter.getCharsetName(exchange, true);
    }

    @Deprecated
    public static String normalizeCharset(String charset) {
        return IOHelper.normalizeCharset(charset);
    }

    @Deprecated
    public static void validateCharset(String charset) throws UnsupportedCharsetException {
        IOHelper.validateCharset(charset);
    }

    private static class EncodingFileWriter
    extends OutputStreamWriter {
        public EncodingFileWriter(File file, String charset) throws FileNotFoundException, UnsupportedEncodingException {
            super((OutputStream)new FileOutputStream(file), charset);
        }
    }

    private static class EncodingFileReader
    extends InputStreamReader {
        public EncodingFileReader(File file, String charset) throws FileNotFoundException, UnsupportedEncodingException {
            super((InputStream)new FileInputStream(file), charset);
        }
    }
}

