package com.foc;

import com.foc.entity.AccessInfo;
import com.foc.service.Sms;
import com.foc.service.SoundMonitorService;

import com.foc.util.PropertiesUtils;
import lombok.extern.log4j.Log4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Properties;

/**
 * @Author: lisu
 * @Date: 2019/4/29 15:35
 * @Description: 安科录音同步任务及数据源监控
 * 1.查看定时任务最后同步时间
 * 2.查看是否有录音文件记录
 * 3.查看安科数据库最后一条数据
 */
@Log4j
public class DbSoundsMonitorTask {

//    private static final Logger logger = LoggerFactory.getLogger(DbSoundsMonitorTask.class);

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0){
            loadConf(Thread.currentThread().getContextClassLoader().getResource("global.properties").getPath());
        }else {
            loadConf(args[0]);
        }
    }

    public static void loadConf(String path) throws Exception {
        Properties properties = PropertiesUtils.getProperties(path);
        //查看定时任务最后同步时间
        SoundMonitorService.init();
        boolean i = SoundMonitorService.test();
        if (i = true){
            //发送短信
            AccessInfo accessInfo = new AccessInfo();
            accessInfo.setAicc("5");
            accessInfo.setAicp("10.68.26.52");
            String result = Sms.sendSms(accessInfo, properties.getProperty("mobile"), "预警：智能首航录音记录显示异常，请处理。");
            System.out.println(result);
            log.info(result);

        }else {
            log.info("没有异常！" );
        }
    }
}
