package com.foc.service;

import com.alibaba.fastjson.JSON;
import com.foc.dao.StatisticalDao;
import com.foc.entity.AcType;
import com.foc.entity.StatisticalEntity;
import com.foc.util.DateUtils;
import com.foc.util.PropertiesUtils;
import com.foc.util.StringUtils;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

/**
 * @author LEGION
 */
public class DynamicFlightService {
    private static final Logger log = LoggerFactory.getLogger(DynamicFlightService.class);

    private static Reader reader;

    private static SqlSessionFactory sqlSessionFactory;

    private static SqlSession session;

    public static void init() {
        try {
            reader = Resources.getResourceAsReader("mybatis-config.xml");
            sqlSessionFactory = new SqlSessionFactoryBuilder().build(reader);
            session = sqlSessionFactory.openSession();
        } catch (IOException e) {
            log.error("连接数据库异常");
            e.printStackTrace();
        }
    }

    public static void sta() {
        //从配置文件中获取需要统计的大机型
        Properties properties = PropertiesUtils.getProperties();
        String verifyAcType = properties.getProperty("verifyAcType");
        if (StringUtils.isEmpty(verifyAcType)) {
            log.error("获取配置文件中机型的文件");
            return;
        }
        //总机型集合
        List<String> verifyAcTypes = Arrays.asList(verifyAcType.split(","));
        StatisticalDao dao = session.getMapper(StatisticalDao.class);
        //获取航班动态表中所有航班性质为J，状态不为CNL，机型为319/A320,321,320neo,330的航线的最后一班时间
        String date = DateUtils.getLastDate();
        List<StatisticalEntity> list = dao.getFlightList(date);
        List<StatisticalEntity> slist = new ArrayList<>();
        List<String> acTypes = dao.getLacTypesByVerifyAcTypes(verifyAcTypes);
        list.forEach(e -> {
            //获取该航线所有论证机型（319/A320,321,320neo,330）的最后执行时间（实际起飞时间）
            String lastDate = dao.getFlightByDepAndArr(e, acTypes, date);
            StatisticalEntity entity = new StatisticalEntity();
            entity.setArrIata(e.getArrIata());
            entity.setArrIataName(e.getArrIataName());
            entity.setDepIata(e.getDepIata());
            entity.setDepIataName(e.getDepIataName());
            entity.setLastAirlineTime(lastDate);
            List<AcType> acTypeList = new ArrayList<>();
            //遍历论证机型查询对应小机型
            for (String str : verifyAcTypes) {
                AcType acType = new AcType();
                acType.setType(str);
                //获取总机型下的子机型集合
                List<String> lacTypes = dao.getLacTypesByVerifyAcType(str);
                if (CollectionUtils.isEmpty(lacTypes)) {
                    continue;
                }
                /**获取该航线特定机型下的最后执行时间
                 1.如果有航班动态时间（实际起飞时间）：
                 状态显示动态日期（status=1）
                 2. 如果没有航班动态时间：
                 （1）有论证记录（查询开航指令集中的航班性质为正班，且申请单类型为：新开重开国内国际）
                 状态可用(status=2)
                 （2）没有论证，状态不可用（status=3）

                 */
                String acTypeLastTime = dao.getFlightByDepAndArr(e, lacTypes, date);
                if (StringUtils.isEmpty(acTypeLastTime)) {
                    //判断是否有论证
                    String verifyDate = dao.getSailingCommand(e, str);
                    if (StringUtils.isEmpty(verifyDate)) {
                        acType.setStatus("3");
                    } else {
                        acType.setStatus("2");
                    }
                } else {
                    acType.setStatus("1");
                    acType.setLastTime(acTypeLastTime);
                }
                acTypeList.add(acType);
            }
            entity.setAirlineJson(JSON.toJSONString(acTypeList));
            entity.setUpdateTime(DateUtils.getTime("yyyy-MM-dd hh:mm:ss"));
            entity.setDelFlag(0);
            slist.add(entity);
        });
        dao.insertOrUpdateBatch(slist);
        session.commit();
    }
}
