package com.foc.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

/**
 * @author zangtao
 */
public class PropertiesUtils {
    private static Properties properties ;

    /**
     * 获取配置文件中配置信息
     */
    static { }

    public static Properties getProperties(String path){
        if(properties == null){
            properties = new Properties();
            try {
                InputStream in = new FileInputStream(path);
                properties.load(in);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return properties;
    }

    public static Properties getProperties(){
        if (properties == null){
            properties = new Properties();
            try {
                properties.load(new InputStreamReader(PropertiesUtils.class.getClassLoader().getResourceAsStream("global.properties"),"UTF-8"));
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return properties;
    }


}
