package com.foc.service;

import com.foc.util.HttpClientUtils;
import com.foc.util.PropertiesUtils;
import lombok.extern.log4j.Log4j2;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Properties;

/**
 * 发邮件
 *
 * @author zangtao
 * @create 2019 - 04 -11 16:25
 */
@Log4j2
public class Email {

    /**
     * 发送邮件
     *
     * @param subject 主题
     * @param body 正文
     * @return
     */
    public static String sendEmail(String subject , String body ){

        //读取配置文件
        Properties properties = PropertiesUtils.getProperties();

        //接口地址
        String emailUrl = properties.getProperty("emailUrl");

        //邮件服务发件人参数
        String fromEmail = properties.getProperty("fromEmail");

        //发件人的内网账号
        String fromName = properties.getProperty("fromName");

        //发件人的密码
        String fromPasswd = properties.getProperty("fromPasswd");

        //收件人
        String toEmail = properties.getProperty("toEmail");

        String aict = properties.getProperty("aict");

        String aicc = properties.getProperty("aicc");

        String aicp = properties.getProperty("aicp");

        String result = null;
        try {
             result = HttpClientUtils.doPost(emailUrl + "?ai.cc="+ aicc + "&ai.ct=" + aict + "&ai.cp="+ aicp
                    + "&fromEmail=" + fromEmail + "&fromPasswd=" + fromPasswd
                    + "&toEmail=" + toEmail + "&subject=" + URLEncoder.encode(subject,"UTF-8")
                    + "&fromName="+ fromName + "&content=" + URLEncoder.encode(body,"UTF-8"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        return result;
    }

}
