package com.foc.service;

import com.alibaba.fastjson.JSON;
import com.foc.dao.SoundsMaxIdDao;
import com.foc.entity.*;
import com.foc.util.DateUtils;
import com.foc.util.PropertiesUtils;
import com.foc.util.StringUtils;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

/**
 * @Author: lisu
 * @Date: 2019/4/29 16:35
 * @Description: 安库录音服务监控任务
 */
public class SoundMonitorService {

    private static final Logger log = LoggerFactory.getLogger(SoundMonitorService.class);

    private static Reader reader;

    private static SqlSessionFactory sqlSessionFactory;

    private static SqlSession session;

    public static void init() {
        try {
            reader = Resources.getResourceAsReader("mybatis-config.xml");
            sqlSessionFactory = new SqlSessionFactoryBuilder().build(reader);
            session = sqlSessionFactory.openSession();
        } catch (IOException e) {
            log.error("连接数据库异常");
            e.printStackTrace();
        }
    }


    /**
     * 判断是否要巡检
     *
     * @return
     */
    public static boolean test() {
        Properties properties = PropertiesUtils.getProperties();
        String interval = properties.getProperty("interval");
        SoundsMaxIdDao soundsMaxIdDao = session.getMapper(SoundsMaxIdDao.class);
        //检查ip锁数据库
        List<String> blackIpList = soundsMaxIdDao.getBlackIpList();
        blackIpList.forEach( (blackIp) -> soundsMaxIdDao.deleteBlackIp(blackIp) );
        session.commit();

        SoundsMaxId maxId = soundsMaxIdDao.getMaxId();
        String updateTime = maxId.getUpdateDate();
        Date date = new Date();
        log.info("当前系统时间:{}",date);
        FocSmsEmailRecord focSmsEmailRecord = new FocSmsEmailRecord();
        focSmsEmailRecord.setCreateTime(date);
        //比较时间，如果相差20分钟没有执行
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime ldt = LocalDateTime.parse(updateTime,df);
        if (DateUtils.until(ldt) > Long.parseLong(interval)){
            log.info("更新时间异常，与最新时间间隔大于20分钟,updateTime:{}", updateTime);
            focSmsEmailRecord.setDescription("更新时间异常，与最新时间间隔大于20分钟,updateTime为" + updateTime);
            focSmsEmailRecord.setMonitorState((short)1);
            soundsMaxIdDao.insertFocRecord(focSmsEmailRecord);
            session.commit();
            return true;
        }
        List<SoundInfo> list = soundsMaxIdDao.getInfo(updateTime);
        if (list == null && list.size() < 1){
            log.info("查询不到记录" );
            focSmsEmailRecord.setDescription("查询不到记录");
            focSmsEmailRecord.setMonitorState((short)0);
            soundsMaxIdDao.insertFocRecord(focSmsEmailRecord);
            session.commit();
            return false;
        }
        for (SoundInfo soundInfo : list){
            //成功且没有url的
            if(StringUtils.isEmpty(soundInfo.getDownloadUrl() )  ){
                log.info("{}该条记录无url:{}",date,soundInfo.toString());
                focSmsEmailRecord.setDescription("该条记录无url" + soundInfo.toString());
                focSmsEmailRecord.setMonitorState((short)1);
                soundsMaxIdDao.insertFocRecord(focSmsEmailRecord);
                session.commit();
                return true;
            }
        }
            log.info("全部成功" );
            focSmsEmailRecord.setDescription("全部成功");
            focSmsEmailRecord.setMonitorState((short)0);
            soundsMaxIdDao.insertFocRecord(focSmsEmailRecord);
            session.commit();
            return false;
    }

    public static void SendEmailAndSms(String aicc, String aicp, String resultCode,String mobile) {
        SoundsMaxIdDao soundsMaxIdDao = session.getMapper(SoundsMaxIdDao.class);
        AccessInfo accessInfo = new AccessInfo();
        accessInfo.setAicc(aicc);
        accessInfo.setAicp(aicp);
        //当前时间
        Instant now = Instant.now().plusMillis(TimeUnit.HOURS.toMillis(8));
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        //判断是否要发送短信   间隔一小时
        FocSmsEmailRecord focSendSmsRecord = soundsMaxIdDao.selectFocSendSmsRecord();
        FocSmsEmailRecord focSendEmailRecord = soundsMaxIdDao.selectFocSendEmailRecord();

        FocSmsEmailRecord focSmsEmailRecord = soundsMaxIdDao.selectLatestOne();
        Date currentTime = focSmsEmailRecord.getCreateTime();

        boolean smsFlag;
        Date smsSendTime = focSendSmsRecord.getSmsSendTime();
        if (smsSendTime == null){
            smsFlag = true;
        }else {
            //判断是否超过了一小时
            long second = currentTime.getTime()-smsSendTime.getTime()/1000;
            if (second/360 < 1){
                smsFlag = true;
            }else {
                smsFlag = false;
            }
        }
        if (smsFlag){
                //发送短信
                String smsResult = Sms.sendSms(accessInfo, mobile, "预警：智能首航录音记录显示异常，请处理。");
                SmsResult rootEntity = JSON.parseObject(smsResult, SmsResult.class);
                if (rootEntity.getResult().getResultCode().equals(resultCode)){
                    log.info("短信发送成功,Time:{},result:{}", now,smsResult);
                    focSmsEmailRecord.setSmsSendTime(date);
                    focSmsEmailRecord.setSmsSendStatus((short)1);
                    focSmsEmailRecord.setSmsErrorLog(smsResult);
                    soundsMaxIdDao.updateSms(focSmsEmailRecord);
                    session.commit();
                }else {
                    log.info("短信发送失败,Time:{},result:{}", now,smsResult);
                    focSmsEmailRecord.setSmsSendStatus((short)0);
                    focSmsEmailRecord.setSmsErrorLog(smsResult);
                    soundsMaxIdDao.updateSms(focSmsEmailRecord);
                    session.commit();
                }
            }

        boolean emailFlag;
        Date emailSendTime = focSendEmailRecord.getEmailSendTime();
        if (emailSendTime == null){
            emailFlag = true;
        }else {
            //判断是否超过了一小时
            long emailSecond = currentTime.getTime()-emailSendTime.getTime()/1000;
            if (emailSecond/360 < 1){
                emailFlag = true;
            }else {
                emailFlag = false;
            }
        }
        if (emailFlag){
            //发送邮件
            String emailResult = Email.sendEmail("录音记录预警","智能首航录音记录显示异常，请处理。");
            EmailResult emailResult1 = JSON.parseObject(emailResult,EmailResult.class);
            if (emailResult1.getResult().getResultCode().equals(resultCode)){
                log.info("邮件发送成功,Time:{},result:{}",now,emailResult);
                focSmsEmailRecord.setEmailSendTime(date);
                focSmsEmailRecord.setEmailSendStatus((short)1);
                focSmsEmailRecord.setSmsErrorLog(emailResult);
                soundsMaxIdDao.updateEmail(focSmsEmailRecord);
                session.commit();
            }else {
                log.info("邮件发送失败,Time:{},result:{}",now,emailResult);
                focSmsEmailRecord.setEmailSendStatus((short)0);
                focSmsEmailRecord.setSmsErrorLog(emailResult);
                soundsMaxIdDao.updateEmail(focSmsEmailRecord);
                session.commit();
            }
        }
    }
}
