package com.foc.service;

import com.alibaba.fastjson.JSON;
import com.foc.dao.StatisticalDao;
import com.foc.entity.AcType;
import com.foc.entity.Dynamics;
import com.foc.entity.StatisticalEntity;
import com.foc.util.DateUtils;
import com.foc.util.PropertiesUtils;
import com.foc.util.StringUtils;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author LEGION
 */
public class DynamicFlightService {
    private static final Logger log = LoggerFactory.getLogger(DynamicFlightService.class);

    private static Reader reader;

    private static SqlSessionFactory sqlSessionFactory;

    private static SqlSession session;

    public static void init() {
        try {
            reader = Resources.getResourceAsReader("mybatis-config.xml");
            sqlSessionFactory = new SqlSessionFactoryBuilder().build(reader);
            session = sqlSessionFactory.openSession();
        } catch (IOException e) {
            log.error("连接数据库异常");
            e.printStackTrace();
        }
    }

    /**
     * 备份明日航班动态数据 std-chn，sta-chn，航班号、起飞机场三字码、目的机场三字码字段
     */
    public static void backupDynamicsTomorrow() {
        StatisticalDao dao = session.getMapper(StatisticalDao.class);
        List<Dynamics> dynamicsList = dao.getDynamicsList(DateUtils.getTomorrow());
        dao.addDynamicsList(dynamicsList);
        session.commit();
    }

    /**
     * 从配置文件中获取需要统计的大机型
     * @return
     */
    private static List<String> getVerifyAcType(){
        List<String> verifyAcTypes = null;
        try {
            Properties properties = PropertiesUtils.getProperties();
            String verifyAcType = properties.getProperty("verifyAcType");
            verifyAcTypes = Arrays.asList(verifyAcType.split(","));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("获取配置文件中机型的文件");
        }
        return verifyAcTypes;
    }

    public static void sta() {
        StatisticalDao dao = session.getMapper(StatisticalDao.class);
        //总机型集合
        List<String> verifyAcTypes = getVerifyAcType();

        //获取航班动态表中所有航班性质为A,J,G，状态不为CNL，子机型为319/A320,321,320neo,330,321neo的航线的最后一班时间
//        String date = DateUtils.getLastDate();
        String date=DateUtils.getTime("yyyy-MM-dd 23:59:59");
        List<StatisticalEntity> list = dao.getFlightList(date);
        List<StatisticalEntity> slist = new ArrayList<>();
        //根据论证机型获取机型下的子机型
        List<String> acTypes = dao.getLacTypesByVerifyAcTypes(verifyAcTypes);
        list.forEach(e -> {
            //获取该航线所有论证机型（319/A320,321,320neo,330）的最后执行时间（实际起飞时间）
            String lastDate = dao.getFlightByDepAndArr(e, acTypes, date);
            //根据航线查询航班执行监控数据
            StatisticalEntity entity = dao.getAirlineStatic(e.getArrIata(), e.getDepIata());
            //将机型数据放入到map中,机型为key，机型最后飞行时间为value
            Map<String, String> map = new HashMap<>();
     //       boolean update = false;
            if (Objects.isNull(entity)) {
                entity = new StatisticalEntity();
            } else {
                String json = entity.getAirlineJson();
                List<AcType> acTypeList = JSON.parseArray(json, AcType.class);
                for (AcType acType : acTypeList) {
                    map.put(acType.getType(), acType.getLastTime());
                }
            }
//            if("HGH".equals(e.getDepIata()) && "YVR".equals(e.getArrIata())){
//                System.out.println("entity:" + JSON.toJSONString(entity));
//                System.out.println("map:" + JSON.toJSONString(map));
//            }
            entity.setArrIata(e.getArrIata());
            entity.setArrIataName(e.getArrIataName());
            entity.setDepIata(e.getDepIata());
            entity.setDepIataName(e.getDepIataName());
            //从备份表中查询是否有该航班，如果有，更新最后执行时间
//            String backupDate = dao.getFromBackUp(entity);
//            if (!StringUtils.isEmpty(backupDate)) {
//               // entity.setLastAirlineTime(lastDate);
//                update = true;
//            }
            entity.setLastAirlineTime(lastDate);
            List<AcType> acTypeList = new ArrayList<>();
            //遍历论证机型查询对应小机型
            for (String str : verifyAcTypes) {
                AcType acType = new AcType();
                acType.setType(str);
                //获取总机型下的子机型集合
                List<String> lacTypes = dao.getLacTypesByVerifyAcType(str);
                if (CollectionUtils.isEmpty(lacTypes)) {
                    continue;
                }
                /**获取该航线特定机型下的最后执行时间
                 1.如果有航班动态时间（实际起飞时间）：
                 判断是否论证，没有（status=3）,有（status=1）
                 2. 如果没有航班动态时间：
                 （1）有论证记录（查询开航指令集中的航班性质为正班包机加班，且申请单类型为：新开重开国内国际）
                 状态可用(status=2)
                 （2）没有论证，状态不可用（status=3）

                 */
                String acTypeLastTime = dao.getFlightByDepAndArr(e, lacTypes, date);

                if (StringUtils.isEmpty(acTypeLastTime)) {
                    //判断是否有论证，判断范围在verify_type为（01，02，03，04），flight_type为（01正班，02加班，03包机，对应前边航班动态中航班类型为J，G，A）
                    String verifyDate = dao.getSailingCommand(e, str);
                    if (StringUtils.isEmpty(verifyDate)) {
                        acType.setStatus("3");
                    } else {
                        acType.setStatus("2");
                    }
                } else {
                    //如果机型最后执行时间和航班最后执行时间相等，则说明该机型执行了最后航班，根据update标识决定是否要更新
//                    if (acTypeLastTime.equals(lastDate) && update) {
//                        acType.setLastTime(acTypeLastTime);
//                        if("HGH".equals(e.getDepIata()) && "YVR".equals(e.getArrIata())){
//                            System.out.println("e:" + e);
//                            System.out.println("LastTime(acTypeLastTime):" + acTypeLastTime);
//                        }
//                    } else {
//                        acType.setLastTime(map.get(str));
//                        if("HGH".equals(e.getDepIata()) && "YVR".equals(e.getArrIata())){
//                            System.out.println("e:" + e);
//                            System.out.println("LastTime(map):" + map.get(str));
//                        }
//                    }
                    acType.setStatus("1");
                    acType.setLastTime(acTypeLastTime);
                }
                acTypeList.add(acType);
            }
            entity.setAirlineJson(JSON.toJSONString(acTypeList));
            entity.setUpdateTime(DateUtils.getTime("yyyy-MM-dd hh:mm:ss"));
            entity.setDelFlag(0);
            slist.add(entity);
        });
        dao.insertOrUpdateBatch(slist);
        session.commit();
        session.close();
    }



}
