package com.foc.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.json.XML;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.foc.dao.StatisticalDao;
import com.foc.entity.DspReleaseInfo;
import com.foc.entity.FlightPlan;
import com.foc.entity.FltPLanInfo;
import com.foc.entity.ResultMsg;
import com.foc.thirdpart.esb.ApiRequest;
import com.foc.thirdpart.esb.EncodeUtil;
import com.foc.thirdpart.esb.HttpClient;
import com.foc.thirdpart.esb.PageParam;
import com.foc.thirdpart.esb.nativehttp.HttpClientImpl;
import com.foc.util.DateUtils;
import com.foc.util.Empty4JUtil;
import com.foc.util.PropertiesUtils;
import com.foc.util.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.*;

/**
 * @author LEGION
 */
public class DspReleaseInfoService {
    private static final Logger log = LoggerFactory.getLogger(DspReleaseInfoService.class);

    private static Reader reader;

    private static SqlSessionFactory sqlSessionFactory;

    private static SqlSession session;

    public static void init() {
        try {
            reader = Resources.getResourceAsReader("mybatis-config.xml");
            sqlSessionFactory = new SqlSessionFactoryBuilder().build(reader);
            session = sqlSessionFactory.openSession();
        } catch (IOException e) {
            log.error("连接数据库异常");
            e.printStackTrace();
        }
    }


    public static void addInfo(List<LocalDate> dates) throws Exception {
        Properties properties = PropertiesUtils.getProperties();
        String gatewayUatUrl = properties.getProperty("esb.security.gateway.uat.url");
        String key = properties.getProperty("esb.security.key");
        String userAccount = properties.getProperty("esb.security.account");
        String password = properties.getProperty("esb.security.password");
        if (StringUtils.isEmpty(gatewayUatUrl) || StringUtils.isEmpty(key)) {
            log.error("获取配置文件中机型的文件");
        }
        StatisticalDao dao = session.getMapper(StatisticalDao.class);
        for (LocalDate date : dates) {
            List<String> flightNoList = dao.getFlightNoList(date);
            System.out.println("开始" + date + "前一天航班号统计，共获取到" + flightNoList.size() + "条数据");
            for (String s : flightNoList) {
                System.out.println("航班号：" + s);
                //生成requestCode
                Map<String, String> map = buildGatewayRequestString(s, key, userAccount, password, date);
                //掉接口
                String resultString = nativeHttpCall(map, gatewayUatUrl, key);
                //解密
                decrypt(resultString, key, password, userAccount, gatewayUatUrl, dao);
            }

        }
    }


    public static Map<String, String> buildGatewayRequestString(String flightNo, String key, String userAccount, String password, LocalDate date) throws UnsupportedEncodingException, GeneralSecurityException {
        Gson gson = new Gson();
        String currentTimeMillisStr = String.valueOf(System.currentTimeMillis());
        /** step1： 参考接口文档 2.4输入参数说明 章节，并组装成json string  **/

        ApiRequest apiRequest = new ApiRequest();
        apiRequest.getOptions().put("flightNos", flightNo);
        apiRequest.getOptions().put("updatedTimeStart", date.plusDays(-1).format(DateTimeFormatter.ISO_LOCAL_DATE) + " 00:00:00");
        apiRequest.getOptions().put("updatedTimeEnd", date.format(DateTimeFormatter.ISO_LOCAL_DATE) + " 00:00:00");
        //分页参数
        PageParam pageParam = new PageParam();
        //从第一页开始
        pageParam.setPageIndex(1);
        //每次查询10条记录
        pageParam.setPageSize(100);
        apiRequest.getOptions().put("pageParam", pageParam);
        String apiRequestJson = gson.toJson(apiRequest);
        log.info("dubbo interface apiRequestJson=" + apiRequestJson);

        /** step2: 构建 gateway 接口 signature 参数**/
        String signature = EncodeUtil.generateToken(userAccount, key, apiRequestJson, currentTimeMillisStr);
        log.info("signature=" + signature);

        /** step3: 构建外网网关接口参数 **/
        Map<String, String> gatewayParam = new HashMap<>();
        //dubbo 接口参数，json 格式
        gatewayParam.put("inParams", apiRequestJson);
        //接口文档中的 2.1 包名与类名
        gatewayParam.put("packageName", "com.hnair.opcnet.api.ods.dsp.GetDspReleaseApi");
        //接口文档中的 2.2 方法名
        gatewayParam.put("methodName", "getDspReleaseInfoByPage");
        //hna-esb-security.xml 文件中的password
        gatewayParam.put("password", password);
        //step2 的签名串
        gatewayParam.put("signature", signature);
        //当前时间string 串
        gatewayParam.put("time", currentTimeMillisStr);

        String gatewayParamStr = gson.toJson(gatewayParam);
        log.info("gatewayParamStr=" + gatewayParamStr);
        //step3 对gatewayParamStr 进行加密，key 来自hna-esb-security.xml 文件中的key
        String requestString = EncodeUtil.encrypt(gatewayParamStr, key);
        log.info("requestString encrypt=" + requestString);

        Map<String, String> requstMap = new HashMap<>();
        requstMap.put("userName", userAccount);
        requstMap.put("requestString", requestString);
        return requstMap;
    }

    public static Map<String, String> buildFltPlanGatewayRequestString(String flightNo, String key, String userAccount, String password, String std, String depIataId, String arrIataId) throws UnsupportedEncodingException, GeneralSecurityException {
        Gson gson = new Gson();
        String currentTimeMillisStr = String.valueOf(System.currentTimeMillis());
        /** step1： 参考接口文档 2.4输入参数说明 章节，并组装成json string  **/

        ApiRequest apiRequest = new ApiRequest();
        apiRequest.getOptions().put("flightNo", flightNo);
        apiRequest.getOptions().put("std", std);
        apiRequest.getOptions().put("depIataId", depIataId);
        apiRequest.getOptions().put("arrIataId", arrIataId);
        apiRequest.getOptions().put("returnPlanContentsXml", "true");
        apiRequest.getOptions().put("returnRecPlanXmlContent", "true");

        String apiRequestJson = gson.toJson(apiRequest);
        log.info("dubbo interface apiRequestJson=" + apiRequestJson);

        /** step2: 构建 gateway 接口 signature 参数**/
        String signature = EncodeUtil.generateToken(userAccount, key, apiRequestJson, currentTimeMillisStr);
        log.info("signature=" + signature);

        /** step3: 构建外网网关接口参数 **/
        Map<String, String> gatewayParam = new HashMap<>();
        //dubbo 接口参数，json 格式
        gatewayParam.put("inParams", apiRequestJson);
        //接口文档中的 2.1 包名与类名
        gatewayParam.put("packageName", "com.hnair.opcnet.api.ods.dsp.GetDspReleaseApi");
        //接口文档中的 2.2 方法名
        gatewayParam.put("methodName", "getFltPLan");
        //hna-esb-security.xml 文件中的password
        gatewayParam.put("password", password);
        //step2 的签名串
        gatewayParam.put("signature", signature);
        //当前时间string 串
        gatewayParam.put("time", currentTimeMillisStr);

        String gatewayParamStr = gson.toJson(gatewayParam);
        log.info("gatewayParamStr=" + gatewayParamStr);
        //step3 对gatewayParamStr 进行加密，key 来自hna-esb-security.xml 文件中的key
        String requestString = EncodeUtil.encrypt(gatewayParamStr, key);
        log.info("requestString encrypt=" + requestString);

        Map<String, String> requstMap = new HashMap<>();
        requstMap.put("userName", userAccount);
        requstMap.put("requestString", requestString);
        return requstMap;
    }

    private static String nativeHttpCall(Map<String, String> params, String gatewayUatUrl, String key) {
        log.info("**********************************************");
        log.info("----nativeHttpCall-----");
        String result = "";
        try {
            HttpClient httpClient = new HttpClientImpl();

            result = httpClient.doPost(gatewayUatUrl, params,
                    HttpClientImpl.DEFAULT_CHARSET, 60000, 60000);
//            log.info("nativeHttpCall result=" + result);
//            log.info("nativeHttpCall decrypt result=" + EncodeUtil.decrypt(result, key));
        } catch (Exception e) {
            e.printStackTrace();
        }
        log.info("**********************************************");
        return result;
    }


    public static void decrypt(String resultString, String key, String password, String account, String gatewayUatUrl, StatisticalDao dao) throws GeneralSecurityException, UnsupportedEncodingException {
        String response = EncodeUtil.decrypt(resultString, key);
        System.out.println(response);
        String nowDate=LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        //转成jsonObject
        JSONObject jsonObject = JSON.parseObject(response);
        //取出jsonObject中的data
        String resultJson = jsonObject.getString("result");
        JSONObject resultJsonObject = JSON.parseObject(resultJson);
        ResultMsg resultMsg = JSONObject.toJavaObject(resultJsonObject, ResultMsg.class);
        if (Objects.nonNull(resultMsg)) {
            if ("0".equals(resultMsg.getResultCode())) {
                //取出jsonObject中的data
                String data = jsonObject.getString("data");
                List<DspReleaseInfo> dspReleaseInfoList = JSON.parseArray(data, DspReleaseInfo.class);
                List<DspReleaseInfo> list = new ArrayList<>();
                if (Empty4JUtil.listIsNotEmpty(dspReleaseInfoList)) {
                    for (DspReleaseInfo ss : dspReleaseInfoList) {
                        if(ss.getStd().contains(nowDate)){
                            continue;
                        }
                        int year = DateTime.of(ss.getStd(), "yyyy-MM-dd HH:mm:ss").year();
                        ss.setDepAirPortName(dao.selectAirPortNameByIataId(ss.getDepIataId()));
                        ss.setArrAirPortName(dao.selectAirPortNameByIataId(ss.getArrIataId()));
                        ss.setDispatcherAccount(dao.selectUserNameByLoginName(ss.getDispatcherName()));
                        ss.setAcTypeName((dao.selectAcTypeNameByAcNo(ss.getAcNo(),year) == null) ? "" : dao.selectAcTypeNameByAcNo(ss.getAcNo(),year));
                        ss.setArrIcaoId(dao.selectIcaoIdByTataId(ss.getArrIataId()));
                        ss.setDepIcaoId(dao.selectIcaoIdByTataId(ss.getDepIataId()));
                        ss.setDelFlag("0");
                        ss.setCreateDate(DateUtils.getTime("yyyy-MM-dd hh:mm:ss"));
                        ss.setUpdateDate(DateUtils.getTime("yyyy-MM-dd hh:mm:ss"));
                        ss.setExtraOilFuelReasonNew(ss.getExtraOilFuelReason());
                        ss.setExtraOilConclusion("合格");
                        list.add(ss);
                    }
                    //调添加接口
                    dao.insertDspReleaseInfo(list);
                    session.commit();
                }
            } else {
                System.out.println("返回值不为0");
            }
        } else {
            System.out.println("返回值为空");
        }

    }

    public static void decryptFlt(Integer staId, String resultString, String key, StatisticalDao dao) throws GeneralSecurityException, UnsupportedEncodingException {
        String response = EncodeUtil.decrypt(resultString, key);
//        System.out.println(response);
        //转成jsonObject
        JSONObject jsonObject = JSON.parseObject(response);
        //取出jsonObject中的data
        String resultJson = jsonObject.getString("result");
        JSONObject resultJsonObject = JSON.parseObject(resultJson);
        ResultMsg resultMsg = JSONObject.toJavaObject(resultJsonObject, ResultMsg.class);
        List<FlightPlan> list = new ArrayList<>();
        FlightPlan flightPlan = null;
        if (Objects.nonNull(resultMsg)) {
            if ("0".equals(resultMsg.getResultCode())) {
                //取出jsonObject中的data
                List<FltPLanInfo> fltPLans = jsonObject.getJSONArray("data").toJavaList(FltPLanInfo.class);
                for (FltPLanInfo fltPLan : fltPLans) {
                    flightPlan = new FlightPlan();
                    BeanUtil.copyProperties(fltPLan, flightPlan);
                    flightPlan.setDynamicsStaId(staId);
                    
                    cn.hutool.json.JSONObject block = null;
                    cn.hutool.json.JSONObject aircraft = null;
                    if (ObjectUtil.equal("0", fltPLan.getCfpFlag()) || ObjectUtil.equal("1", fltPLan.getCfpFlag())) {
                        block = XML.toJSONObject(fltPLan.getPlanContentsXml()).getJSONObject("FlightPlan").getJSONObject("Block");
                        aircraft = XML.toJSONObject(fltPLan.getPlanContentsXml()).getJSONObject("FlightPlan").getJSONObject("Aircraft");
                        flightPlan.setTakeoffWeight(aircraft.getJSONObject("Weights").getInt("takeoff", 0));
                        flightPlan.setLandingWeight(aircraft.getJSONObject("Weights").getInt("landing", 0));
                        flightPlan.setPayloadWeight(aircraft.getJSONObject("Weights").getInt("payload", 0));
                        flightPlan.setKalCargoLoad(aircraft.getJSONObject("Weights").getInt("kalCargoLoad", 0));
                        flightPlan.setZeroFuel(aircraft.getJSONObject("Weights").getInt("zeroFuel", 0));
                        flightPlan.setMaximumFuelCapacity(aircraft.getJSONObject("DataBase").getJSONObject("Fuels").getInt("maximumFuelCapacity", 0));
                        flightPlan.setLimitingTakeoffWeight(aircraft.getJSONObject("CustomerOverrides").getJSONObject("Weights").getInt("limitingTakeoffWeight", 0));
                        flightPlan.setLimitingLandingWeight(aircraft.getJSONObject("CustomerOverrides").getJSONObject("Weights").getInt("limitingLandingWeight", 0));
                        flightPlan.setTotal(block.getJSONObject("Total").getInt("fuel", 0));
                        flightPlan.setTotalTime(block.getJSONObject("Total").getStr("time"));
                        flightPlan.setTrip(block.getJSONObject("Trip").getInt("fuel", 0));
                        flightPlan.setTripTime(block.getJSONObject("Trip").getStr("time"));
                        flightPlan.setTripDist(block.getJSONObject("Trip").getInt("dist", 0));
                        flightPlan.setArrivalTime(block.getJSONObject("Trip").getStr("arrivalTime"));
                        flightPlan.setAlternateFuel(block.getJSONObject("Alternate").getInt("fuel", 0));
                        flightPlan.setAlternateDist(block.getJSONObject("Alternate").getInt("dist", 0));
                        flightPlan.setAlternateTime(block.getJSONObject("Alternate").getStr("time"));
                        flightPlan.setTaxiOut(block.getJSONObject("TaxiOut").getInt("fuel", 0));
                        flightPlan.setTaxiOutTime(block.getJSONObject("TaxiOut").getStr("time"));
                        flightPlan.setHold(block.getJSONObject("Hold").getInt("fuel", 0));
                        flightPlan.setReserve(block.getJSONObject("Reserve").getInt("fuel", 0));
                        flightPlan.setReserveTime(block.getJSONObject("Reserve").getStr("time"));
                        flightPlan.setExtra(block.getJSONObject("Extra").getInt("fuel", 0));
                        flightPlan.setExtraTime(block.getJSONObject("Extra").getStr("time"));
                        flightPlan.setCustomExtraTime(block.getJSONObject("CustomExtra").getStr("time"));

                        if (ObjectUtil.equal(1, fltPLan.getCfpFlag())) {
                            flightPlan.setEtop(block.getJSONObject("Etop").getInt("fuel", 0));
                            flightPlan.setEtopTime(block.getJSONObject("Etop").getStr("time"));
                        }
                    } else if (ObjectUtil.equal("2", fltPLan.getCfpFlag()) || ObjectUtil.equal("3", fltPLan.getCfpFlag())) {
                        block = XML.toJSONObject(fltPLan.getRecPlanContentsXml()).getJSONObject("FlightPlan").getJSONObject("Block");
                        aircraft = XML.toJSONObject(fltPLan.getRecPlanContentsXml()).getJSONObject("FlightPlan").getJSONObject("Aircraft");
                        flightPlan.setTakeoffWeight(aircraft.getJSONObject("Weights").getInt("takeoff", 0));
                        flightPlan.setLandingWeight(aircraft.getJSONObject("Weights").getInt("landing", 0));
                        flightPlan.setPayloadWeight(aircraft.getJSONObject("Weights").getInt("payload", 0));
                        flightPlan.setKalCargoLoad(aircraft.getJSONObject("Weights").getInt("kalCargoLoad", 0));
                        flightPlan.setZeroFuel(aircraft.getJSONObject("Weights").getInt("zeroFuel", 0));
                        flightPlan.setMaximumFuelCapacity(aircraft.getJSONObject("DataBase").getJSONObject("Fuels").getInt("maximumFuelCapacity", 0));
                        flightPlan.setLimitingTakeoffWeight(aircraft.getJSONObject("CustomerOverrides").getJSONObject("Weights").getInt("limitingTakeoffWeight", 0));
                        flightPlan.setLimitingLandingWeight(aircraft.getJSONObject("CustomerOverrides").getJSONObject("Weights").getInt("limitingLandingWeight", 0));
                        flightPlan.setTotal(block.getJSONObject("Total").getInt("fuel", 0));
                        flightPlan.setTotalTime(block.getJSONObject("Total").getStr("time"));
                        flightPlan.setTrip(block.getJSONObject("Trip").getInt("fuel", 0));
                        flightPlan.setTripTime(block.getJSONObject("Trip").getStr("time"));
                        flightPlan.setTripDist(block.getJSONObject("Trip").getInt("dist", 0));
                        flightPlan.setArrivalTime(block.getJSONObject("Trip").getStr("arrivalTime"));
                        flightPlan.setAlternateFuel(block.getJSONObject("Alternate").getInt("fuel", 0));
                        flightPlan.setAlternateDist(block.getJSONObject("Alternate").getInt("dist", 0));
                        flightPlan.setAlternateTime(block.getJSONObject("Alternate").getStr("time"));
                        flightPlan.setTaxiOut(block.getJSONObject("TaxiOut").getInt("fuel", 0));
                        flightPlan.setTaxiOutTime(block.getJSONObject("TaxiOut").getStr("time"));
                        flightPlan.setHold(block.getJSONObject("Hold").getInt("fuel", 0));
                        flightPlan.setReserve(block.getJSONObject("Reserve").getInt("fuel", 0));
                        flightPlan.setReserveTime(block.getJSONObject("Reserve").getStr("time"));
                        flightPlan.setExtra(block.getJSONObject("Extra").getInt("fuel", 0));
                        flightPlan.setExtraTime(block.getJSONObject("Extra").getStr("time"));
                        flightPlan.setCustomExtraTime(block.getJSONObject("CustomExtra").getStr("time"));
                        if (ObjectUtil.equal(3, fltPLan.getCfpFlag())) {
                            flightPlan.setEtop(block.getJSONObject("Etop").getInt("fuel", 0));
                            flightPlan.setEtopTime(block.getJSONObject("Etop").getStr("time"));
                        }
                    }
                    flightPlan.setPlanLeftOver(flightPlan.getTotal() - flightPlan.getTrip() - flightPlan.getTaxiOut());
                    flightPlan.setCreateDate(DateTime.now());
                    flightPlan.setUpdateDate(DateTime.now());
                    list.add(flightPlan);
                    fltPLan = null;
                }
                dao.insertFltPlanInfo(list);
                fltPLans = null;
                resultMsg = null;
            } else {
                System.out.println("返回值不为0");
            }
        } else {
            System.out.println("返回值为空");
        }

    }

    public static void addPltPlan(LocalDate dateTime) throws Exception {
        Properties properties = PropertiesUtils.getProperties();
        String gatewayUatUrl = properties.getProperty("esb.security.gateway.uat.url");
        String key = properties.getProperty("esb.security.key");
        String userAccount = properties.getProperty("esb.security.account");
        String password = properties.getProperty("esb.security.password");
        if (StringUtils.isEmpty(gatewayUatUrl) || StringUtils.isEmpty(key)) {
            log.error("获取配置文件中机型的文件");
        }
        StatisticalDao dao = session.getMapper(StatisticalDao.class);
        List<Integer> ids = new ArrayList<>();
        List<DspReleaseInfo> dspReleaseInfoList = dao.selectReleaseInfoByDate(dateTime.format(DateTimeFormatter.ISO_LOCAL_DATE) + " 00:00:00", dateTime.format(DateTimeFormatter.ISO_LOCAL_DATE)+" 23:59:59");
        for (DspReleaseInfo ss : dspReleaseInfoList) {
            //生成requestCode
            Map<String, String> fltMap = buildFltPlanGatewayRequestString(ss.getFlightNo(), key, userAccount, password, ss.getStd(), ss.getDepIataId(), ss.getArrIataId());
            //掉接口
            String fltResultString = nativeHttpCall(fltMap, gatewayUatUrl, key);
            decryptFlt(ss.getId(), fltResultString, key, dao);
            ids.add(ss.getId());

        }
        session.commit();

    }

    public static void addHistoryPltPlan()  {

        LocalDateTime endTime = LocalDateTimeUtil.parse("2022-03-14", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        System.out.println(endTime);
        LocalDateTime startTime = LocalDateTimeUtil.parse("2022-01-01", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        System.out.println(startTime);
        long days = LocalDateTimeUtil.between(startTime,endTime, ChronoUnit.DAYS);
        System.out.println(days);
        for (int i = 0; i <=days; i++) {
            String plus = startTime.plusDays(i).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            LocalDate parse = LocalDate.parse(plus);
            System.out.println(parse);
            try {
                addPltPlan(parse);
            }catch (Exception e){
                log.error("std:"+parse+e.getMessage());
            }

        }

    }

    public static void main(String[] args) {
        LocalDateTime endTime = LocalDateTimeUtil.parse("2022-03-14", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        System.out.println(endTime);
        LocalDateTime startTime = LocalDateTimeUtil.parse("2022-01-01", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        System.out.println(startTime);
        long days = LocalDateTimeUtil.between(startTime,endTime, ChronoUnit.DAYS);
        System.out.println(days);
        String format1 = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        for (int i = 0; i <=days; i++) {
            LocalDateTime plus = startTime.plusDays(i);
            String format = plus.format(DateTimeFormatter.ofPattern("yyyy-MM-dd 00:00:00"));
            if(format.contains(format1)){
                continue;
            }
            String plusStr = startTime.plusDays(i).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            LocalDate parse = LocalDate.parse(plusStr);
            System.out.println(parse);
        }

    }

}
