package com.foc.util;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;

/**
 * @author lisu
 */
public class DateUtils {
    /**
     * 计算当前日期与{@code endDate}的间隔天数
     *
     * @param time
     * @return 间隔分钟
     */
    public static long until(LocalDateTime time) {
        return Math.abs(LocalDateTime.now().until(time, ChronoUnit.MINUTES));
    }

    public static String getTime(String formatType) {
        SimpleDateFormat format = new SimpleDateFormat(formatType);
        return format.format(System.currentTimeMillis());
    }

    public static String getLastDate(){
        Calendar cal=Calendar.getInstance();
        cal.add(Calendar.DATE,-1);
        Date d=cal.getTime();
        SimpleDateFormat sp=new SimpleDateFormat("yyyy-MM-dd");
        String time =sp.format(d);
        return time;
    }
}
