/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.util.IOHelper;

public class FileInputStreamCache
extends InputStream
implements StreamCache {
    private InputStream stream;
    private File file;

    public FileInputStreamCache(File file) throws FileNotFoundException {
        this.file = file;
        this.stream = IOHelper.buffered(new FileInputStream(file));
    }

    @Override
    public void close() {
        if (this.stream != null) {
            IOHelper.close(this.stream);
        }
    }

    @Override
    public void reset() {
        try {
            this.close();
            this.stream = IOHelper.buffered(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeCamelException("Cannot reset stream from file " + this.file, e);
        }
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        IOHelper.copy(this.getInputStream(), os);
    }

    @Override
    public int available() throws IOException {
        return this.getInputStream().available();
    }

    @Override
    public int read() throws IOException {
        return this.getInputStream().read();
    }

    protected InputStream getInputStream() {
        return this.stream;
    }
}

