package com.foc.dao;

import com.foc.entity.StatisticalEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author LEGION
 */
public interface StatisticalDao {
    /**
     * 获取所有类型为J，状态为ATA的航线
     *
     * @return
     */
    List<StatisticalEntity> getFlightList();

    /**
     * 根据起飞地和到达地获取航线最近时间
     *
     * @param entity
     * @param acTypes
     * @return
     */
    String getFlightByDepAndArr(@Param(value = "entity") StatisticalEntity entity, @Param(value = "acTypes") List acTypes);

    /**
     * 根据论证机型获取小机型
     *
     * @param verifyAcType
     * @return
     */
    List<String> getLacTypesByVerifyAcType(String verifyAcType);

    /**
     * 根据论证机型获取小机型
     * @param verifyAcTypes
     * @return
     */
    List<String> getLacTypesByVerifyAcTypes(List<String> verifyAcTypes);

    /**
     * 查询开航指令
     *
     * @param entity
     * @param verifyAcType
     * @return
     */
    int getSailingCommand(@Param(value = "entity") StatisticalEntity entity, @Param(value = "verifyAcType") String verifyAcType);

    /**
     * 批量新增或修改
     *
     * @param list
     */
    void insertOrUpdateBatch(List<StatisticalEntity> list);
}
