package com.foc.service;

import com.foc.entity.AccessInfo;
import com.foc.util.HttpClientUtils;
import com.foc.util.PropertiesUtil;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Properties;


/**
 * 发送短信
 *
 * @author zangtao
 * @create 2019 - 04 -11 15:35
 */
public class Sms {

    private static final Logger logger = LoggerFactory.getLogger(Sms.class);

    /**
     * 发送短信
     *
     * @param accessInfo 接口公共信息
     * @param mobile     手机号
     * @param msg        短信内容
     * @return
     */
    public static String sendSms(AccessInfo accessInfo, String mobile, String msg) {
        //读取配置文件
        Properties properties = PropertiesUtil.getProperties();
        String smsUrl = properties.getProperty("smsUrl");
        String result;

        result = HttpClientUtils.doGet(smsUrl + "?ai.cp=" + accessInfo.getAicp() + "&ai.cc=" + accessInfo.getAicc()
                    + "&mobile=" + mobile + "&msg=" + msg );

//        HttpClient httpClient = HttpClients.createDefault();
//        try {
//            HttpPost httpPost = new HttpPost(smsUrl + "?ai.cp=" + accessInfo.getAicp() + "&ai.cc=" + accessInfo.getAicc()
//                    + "&mobile=" + mobile + "&msg=" + msg);
//            HttpResponse response = httpClient.execute(httpPost);
//            logger.info(response.toString());
//            return response.toString();
//        } catch (Exception ex) {
//            ex.printStackTrace();
//        }

        return result;
    }

//    public static void main(String[] args) {
//        AccessInfo accessInfo = new AccessInfo();
//        accessInfo.setAicc("5");
//        accessInfo.setAicp("10.68.26.52");
////        accessInfo.setAict("21");
//        String res = Sms.sendSms(accessInfo, "13222650486", "HelloWorld");
//        System.out.println(res);
//    }
}
