/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StatefulService;
import org.apache.camel.api.management.ManagedInstance;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.management.mbean.ManagedPerformanceCounter;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.util.ServiceHelper;

@ManagedResource(description="Managed Processor")
public class ManagedProcessor
extends ManagedPerformanceCounter
implements ManagedInstance,
ManagedProcessorMBean {
    private final CamelContext context;
    private final Processor processor;
    private final ProcessorDefinition<?> definition;
    private final String id;
    private Route route;

    public ManagedProcessor(CamelContext context, Processor processor, ProcessorDefinition<?> definition) {
        this.context = context;
        this.processor = processor;
        this.definition = definition;
        this.id = definition.idOrCreate(context.getNodeIdFactory());
        boolean enabled = context.getManagementStrategy().getStatisticsLevel() == ManagementStatisticsLevel.All;
        this.setStatisticsEnabled(enabled);
    }

    public CamelContext getContext() {
        return this.context;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public ProcessorDefinition<?> getDefinition() {
        return this.definition;
    }

    public Route getRoute() {
        return this.route;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    @Override
    public String getState() {
        if (this.processor instanceof StatefulService) {
            ServiceStatus status = ((StatefulService)((Object)this.processor)).getStatus();
            return status.name();
        }
        return ServiceStatus.Started.name();
    }

    @Override
    public String getCamelId() {
        return this.context.getName();
    }

    @Override
    public String getRouteId() {
        if (this.route != null) {
            return this.route.getId();
        }
        return null;
    }

    @Override
    public String getProcessorId() {
        return this.id;
    }

    @Override
    public void start() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        ServiceHelper.startService(this.getProcessor());
    }

    @Override
    public void stop() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        ServiceHelper.stopService(this.getProcessor());
    }

    @Override
    public Object getInstance() {
        return this.processor;
    }
}

