/*
 * Decompiled with CFR 0.152.
 */
package com.opendata.api.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ODPLogger {
    private static final Log log = LogFactory.getLog((String)"odp.log");
    private static boolean needEnableLogger = true;

    public static void setNeedEnableLogger(boolean needEnableLogger) {
        ODPLogger.needEnableLogger = needEnableLogger;
    }

    public static void logCommError(Exception e, String url, String appId, Map<String, String> params) {
        if (!needEnableLogger) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ODPLogger.appendLog(params, sb);
        ODPLogger.logCommError(e, url, appId, sb.toString());
    }

    public static void logCommError(Exception e, String urlStr, String appId, String bodyContent) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        String rspCode = "";
        StringBuilder sb = new StringBuilder();
        sb.append(df.format(new Date()));
        sb.append("_");
        sb.append(appId);
        sb.append("_");
        sb.append(urlStr);
        sb.append("_");
        sb.append(rspCode);
        sb.append("_");
        sb.append(String.valueOf(e.getMessage()).replaceAll("\r\n", " "));
        sb.append(bodyContent);
        log.error((Object)sb.toString());
    }

    private static void appendLog(Map map, StringBuilder sb) {
        boolean first = true;
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            if (!first) {
                sb.append("&");
            } else {
                first = false;
            }
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
    }
}

