package com.foc;

import com.alibaba.fastjson.JSON;
import com.foc.entity.AccessInfo;
import com.foc.entity.SmsResult;
import com.foc.service.Sms;
import com.foc.service.SoundMonitorService;
import com.foc.util.PropertiesUtils;
import lombok.extern.log4j.Log4j2;

import java.util.Date;
import java.util.Properties;

/**
 * @Author: lisu
 * @Date: 2019/4/29 15:35
 * @Description: 安科录音同步任务及数据源监控
 * 1.查看定时任务最后同步时间
 * 2.查看是否有录音文件记录
 * 3.查看安科数据库最后一条数据
 */
@Log4j2
public class DbSoundsMonitorTask {

//    private static final Logger logger = LoggerFactory.getLogger(DbSoundsMonitorTask.class);

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0){
            //本地启动是可以。到了服务器变成了java.io.FileNotFoundException: file:/data/smsAndEmailTest/task-3.0-SNAPSHOT.jar!/global.properties (No such file or directory)
            //loadConf(Thread.currentThread().getContextClassLoader().getResource("global.properties").getPath());
            Properties properties = PropertiesUtils.getProperties();
            load(properties);
        }else {
            loadConf(args[0]);
        }
    }

    public static void loadConf(String path) throws Exception {
        Properties properties = PropertiesUtils.getProperties(path);
        load(properties);
    }

    public static void load(Properties properties){
        String aicc = properties.getProperty("aicc");
        String aicp = properties.getProperty("aicp");
        String resultCode = properties.getProperty("resultCode");
        //查看定时任务最后同步时间
        SoundMonitorService.init();
        boolean i = SoundMonitorService.test();
        if (i){
            //发送短信
            AccessInfo accessInfo = new AccessInfo();
            accessInfo.setAicc(aicc);
            accessInfo.setAicp(aicp);
            String result = Sms.sendSms(accessInfo, properties.getProperty("mobile"), "预警：智能首航录音记录显示异常，请处理。");
            SmsResult rootEntity = JSON.parseObject(result, SmsResult.class);
            if (rootEntity.getResult().getResultCode().equals(resultCode)){
                log.info("发送成功,Time："+ new Date() +"result："+result);
            }else {
                log.info("发送失败,Time："+ new Date() +"result："+result);
            }
        }else {
            log.info("没有异常！" );
        }
    }

}
