package com.foc.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.foc.dao.StatisticalDao;
import com.foc.entity.DspReleaseInfo;
import com.foc.entity.ResultMsg;
import com.foc.thirdpart.esb.ApiRequest;
import com.foc.thirdpart.esb.EncodeUtil;
import com.foc.thirdpart.esb.HttpClient;
import com.foc.thirdpart.esb.PageParam;
import com.foc.thirdpart.esb.nativehttp.HttpClientImpl;
import com.foc.util.DateUtils;
import com.foc.util.Empty4JUtil;
import com.foc.util.PropertiesUtils;
import com.foc.util.StringUtils;
import com.google.gson.Gson;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.*;

/**
 * @author LEGION
 */
public class DspReleaseInfoService {
    private static final Logger log = LoggerFactory.getLogger(DspReleaseInfoService.class);

    private static Reader reader;

    private static SqlSessionFactory sqlSessionFactory;

    private static SqlSession session;

    public static void init() {
        try {
            reader = Resources.getResourceAsReader("mybatis-config.xml");
            sqlSessionFactory = new SqlSessionFactoryBuilder().build(reader);
            session = sqlSessionFactory.openSession();
        } catch (IOException e) {
            log.error("连接数据库异常");
            e.printStackTrace();
        }
    }


    public static void addInfo() throws Exception {
        Properties properties = PropertiesUtils.getProperties();
        String gatewayUatUrl = properties.getProperty("esb.security.gateway.uat.url");
        String key = properties.getProperty("esb.security.key");
        String userAccount = properties.getProperty("esb.security.account");
        String password = properties.getProperty("esb.security.password");
        if (StringUtils.isEmpty(gatewayUatUrl) || StringUtils.isEmpty(key)) {
            log.error("获取配置文件中机型的文件");
        }

        StatisticalDao dao = session.getMapper(StatisticalDao.class);
        List<String> flightNoList = dao.getFlightNoList();
        for (String s : flightNoList
        ) {
            //生成requestCode
            Map<String, String> map = buildGatewayRequestString(s, key, userAccount, password);
            //掉接口
            String resultString = nativeHttpCall(map, gatewayUatUrl, key);
            //解密
            decrypt(resultString, key, dao);
        }
        session.commit();
    }


    public static Map<String, String> buildGatewayRequestString(String flightNo, String key, String userAccount, String password) throws UnsupportedEncodingException, GeneralSecurityException {
        Gson gson = new Gson();
        String currentTimeMillisStr = String.valueOf(System.currentTimeMillis());
        /** step1： 参考接口文档 2.4输入参数说明 章节，并组装成json string  **/

        ApiRequest apiRequest = new ApiRequest();
        apiRequest.getOptions().put("flightNos", flightNo);
        apiRequest.getOptions().put("stdTimeStart", DateUtils.getTodayStartTime());
        apiRequest.getOptions().put("stdTimeEnd", DateUtils.getTodayEndTime());
        //分页参数
        PageParam pageParam = new PageParam();
        //从第一页开始
        pageParam.setPageIndex(1);
        //每次查询10条记录
        pageParam.setPageSize(100);
        apiRequest.getOptions().put("pageParam", pageParam);
        String apiRequestJson = gson.toJson(apiRequest);
        log.info("dubbo interface apiRequestJson=" + apiRequestJson);

        /** step2: 构建 gateway 接口 signature 参数**/
        String signature = EncodeUtil.generateToken(userAccount, key, apiRequestJson, currentTimeMillisStr);
        log.info("signature=" + signature);

        /** step3: 构建外网网关接口参数 **/
        Map<String, String> gatewayParam = new HashMap<>();
        //dubbo 接口参数，json 格式
        gatewayParam.put("inParams", apiRequestJson);
        //接口文档中的 2.1 包名与类名
        gatewayParam.put("packageName", "com.hnair.opcnet.api.ods.dsp.GetDspReleaseApi");
        //接口文档中的 2.2 方法名
        gatewayParam.put("methodName", "getDspReleaseInfoByPage");
        //hna-esb-security.xml 文件中的password
        gatewayParam.put("password", password);
        //step2 的签名串
        gatewayParam.put("signature", signature);
        //当前时间string 串
        gatewayParam.put("time", currentTimeMillisStr);

        String gatewayParamStr = gson.toJson(gatewayParam);
        log.info("gatewayParamStr=" + gatewayParamStr);
        //step3 对gatewayParamStr 进行加密，key 来自hna-esb-security.xml 文件中的key
        String requestString = EncodeUtil.encrypt(gatewayParamStr, key);
        log.info("requestString encrypt=" + requestString);

        Map<String, String> requstMap = new HashMap<>();
        requstMap.put("userName", userAccount);
        requstMap.put("requestString", requestString);
        return requstMap;
    }


    private static String nativeHttpCall(Map<String, String> params, String gatewayUatUrl, String key) {
        log.info("**********************************************");
        log.info("----nativeHttpCall-----");
        String result = "";
        try {
            HttpClient httpClient = new HttpClientImpl();

            result = httpClient.doPost(gatewayUatUrl, params,
                    HttpClientImpl.DEFAULT_CHARSET, 60000, 60000);
            log.info("nativeHttpCall result=" + result);
            log.info("nativeHttpCall decrypt result=" + EncodeUtil.decrypt(result, key));
        } catch (Exception e) {
            e.printStackTrace();
        }
        log.info("**********************************************");
        return result;
    }


    public static void decrypt(String resultString, String key, StatisticalDao dao) throws GeneralSecurityException, UnsupportedEncodingException {
        String response = EncodeUtil.decrypt(resultString, key);
        System.out.println(response);
        //转成jsonObject
        JSONObject jsonObject = JSON.parseObject(response);
        //取出jsonObject中的data
        String resultJson = jsonObject.getString("result");
        JSONObject resultJsonObject = JSON.parseObject(resultJson);
        ResultMsg resultMsg = JSONObject.toJavaObject(resultJsonObject, ResultMsg.class);
        if (Objects.nonNull(resultMsg)) {
            if ("0".equals(resultMsg.getResultCode())) {
                //取出jsonObject中的data
                String data = jsonObject.getString("data");
                List<DspReleaseInfo> dspReleaseInfoList = JSON.parseArray(data, DspReleaseInfo.class);
                if (Empty4JUtil.listIsNotEmpty(dspReleaseInfoList)) {
                    for (DspReleaseInfo ss : dspReleaseInfoList
                    ) {
                        ss.setDelFlag("0");
                        ss.setCreateDate(DateUtils.getTime("yyyy-MM-dd hh:mm:ss"));
                        ss.setUpdateDate(DateUtils.getTime("yyyy-MM-dd hh:mm:ss"));
                    }
                    //调添加接口
                    dao.insertDspReleaseInfo(dspReleaseInfoList);
                }
            }
        }

    }
}
