/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class URISupport {
    private static final Pattern SECRETS = Pattern.compile("([?&][^=]*(?:passphrase|password|secretKey)[^=]*)=([^&]*)", 2);
    private static final Pattern USERINFO_PASSWORD = Pattern.compile("(.*://.*:)(.*)(@)");
    private static final String CHARSET = "UTF-8";

    private URISupport() {
    }

    public static String sanitizeUri(String uri) {
        String sanitized = uri;
        if (uri != null) {
            sanitized = SECRETS.matcher(sanitized).replaceAll("$1=******");
            sanitized = USERINFO_PASSWORD.matcher(sanitized).replaceFirst("$1******$3");
        }
        return sanitized;
    }

    public static Map<String, Object> parseQuery(String uri) throws URISyntaxException {
        if (uri != null && uri.endsWith("&")) {
            throw new URISyntaxException(uri, "Invalid uri syntax: Trailing & marker found. Check the uri and remove the trailing & marker.");
        }
        try {
            LinkedHashMap<String, Object> rc = new LinkedHashMap<String, Object>();
            if (uri != null) {
                String[] parameters;
                for (String parameter : parameters = uri.split("&")) {
                    int p = parameter.indexOf("=");
                    if (p >= 0) {
                        String name = URLDecoder.decode(parameter.substring(0, p), CHARSET);
                        String value = URLDecoder.decode(parameter.substring(p + 1).replaceAll("%", "%25"), CHARSET);
                        if (rc.containsKey(name)) {
                            List list;
                            Object existing = rc.get(name);
                            if (existing instanceof List) {
                                list = CastUtils.cast((List)existing);
                            } else {
                                String s;
                                list = new ArrayList();
                                String string = s = existing != null ? existing.toString() : null;
                                if (s != null) {
                                    list.add(s);
                                }
                            }
                            list.add(value);
                            rc.put(name, list);
                            continue;
                        }
                        rc.put(name, value);
                        continue;
                    }
                    rc.put(parameter, null);
                }
            }
            return rc;
        }
        catch (UnsupportedEncodingException e) {
            URISyntaxException se = new URISyntaxException(e.toString(), "Invalid encoding");
            se.initCause(e);
            throw se;
        }
    }

    public static Map<String, Object> parseParameters(URI uri) throws URISyntaxException {
        String query = uri.getQuery();
        if (query == null) {
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            int idx = schemeSpecificPart.indexOf(63);
            if (idx < 0) {
                return new LinkedHashMap<String, Object>(0);
            }
            query = schemeSpecificPart.substring(idx + 1);
        } else {
            query = URISupport.stripPrefix(query, "?");
        }
        return URISupport.parseQuery(query);
    }

    public static URI createURIWithQuery(URI uri, String query) throws URISyntaxException {
        ObjectHelper.notNull(uri, "uri");
        String s = uri.toString();
        String before = ObjectHelper.before(s, "?");
        if (before != null) {
            s = before;
        }
        if (query != null) {
            s = s + "?" + query;
        }
        if (!s.contains("#") && uri.getFragment() != null) {
            s = s + "#" + uri.getFragment();
        }
        return new URI(s);
    }

    public static String stripPrefix(String value, String prefix) {
        if (value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    public static String createQueryString(Map<Object, Object> options) throws URISyntaxException {
        try {
            if (options.size() > 0) {
                StringBuilder rc = new StringBuilder();
                boolean first = true;
                for (Object o : options.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        rc.append("&");
                    }
                    String key = (String)o;
                    Object value = options.get(key);
                    if (value instanceof List) {
                        List list = (List)value;
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            String s = (String)it.next();
                            URISupport.appendQueryStringParameter(key, s, rc);
                            if (!it.hasNext()) continue;
                            rc.append("&");
                        }
                        continue;
                    }
                    String s = value != null ? value.toString() : null;
                    URISupport.appendQueryStringParameter(key, s, rc);
                }
                return rc.toString();
            }
            return "";
        }
        catch (UnsupportedEncodingException e) {
            URISyntaxException se = new URISyntaxException(e.toString(), "Invalid encoding");
            se.initCause(e);
            throw se;
        }
    }

    private static void appendQueryStringParameter(String key, String value, StringBuilder rc) throws UnsupportedEncodingException {
        rc.append(URLEncoder.encode(key, CHARSET));
        if (value != null) {
            rc.append("=");
            rc.append(URLEncoder.encode(value, CHARSET));
        }
    }

    public static URI createRemainingURI(URI originalURI, Map<Object, Object> params) throws URISyntaxException {
        String s = URISupport.createQueryString(params);
        if (s.length() == 0) {
            s = null;
        }
        return URISupport.createURIWithQuery(originalURI, s);
    }

    public static String normalizeUri(String uri) throws URISyntaxException, UnsupportedEncodingException {
        int idx;
        URI u = new URI(UnsafeUriCharactersEncoder.encode(uri));
        String path = u.getSchemeSpecificPart();
        String scheme = u.getScheme();
        if (scheme == null || path == null) {
            return uri;
        }
        if (path.startsWith("//")) {
            path = path.substring(2);
        }
        if ((idx = path.indexOf(63)) != -1) {
            path = path.substring(0, idx);
        }
        path = UnsafeUriCharactersEncoder.encode(path);
        Map<String, Object> parameters = URISupport.parseParameters(u);
        if (parameters.isEmpty()) {
            return URISupport.buildUri(scheme, path, null);
        }
        ArrayList<String> keys = new ArrayList<String>(parameters.keySet());
        Collections.sort(keys);
        LinkedHashMap<Object, Object> sorted = new LinkedHashMap<Object, Object>(parameters.size());
        for (String key : keys) {
            sorted.put(key, parameters.get(key));
        }
        String query = URISupport.createQueryString(sorted);
        return URISupport.buildUri(scheme, path, query);
    }

    private static String buildUri(String scheme, String path, String query) {
        return scheme + "://" + path + (query != null ? "?" + query : "");
    }
}

