/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.processor.loadbalancer.DistributionRatio;
import org.apache.camel.processor.loadbalancer.QueueLoadBalancer;

public abstract class WeightedLoadBalancer
extends QueueLoadBalancer {
    private List<Integer> distributionRatioList = new ArrayList<Integer>();
    private ArrayList<DistributionRatio> runtimeRatios = new ArrayList();

    public WeightedLoadBalancer(List<Integer> distributionRatios) {
        this.deepCloneDistributionRatios(distributionRatios);
        this.loadRuntimeRatios(distributionRatios);
    }

    protected void deepCloneDistributionRatios(List<Integer> distributionRatios) {
        for (Integer value : distributionRatios) {
            this.distributionRatioList.add(value);
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.getProcessors().size() != this.getDistributionRatioList().size()) {
            throw new IllegalArgumentException("Loadbalacing with " + this.getProcessors().size() + " should match number of distributions " + this.getDistributionRatioList().size());
        }
    }

    protected void loadRuntimeRatios(List<Integer> distributionRatios) {
        int position = 0;
        for (Integer value : distributionRatios) {
            this.runtimeRatios.add(new DistributionRatio(position++, value));
        }
    }

    protected boolean isRuntimeRatiosZeroed() {
        boolean cleared = true;
        for (DistributionRatio runtimeRatio : this.runtimeRatios) {
            if (runtimeRatio.getRuntimeWeight() <= 0) continue;
            cleared = false;
        }
        return cleared;
    }

    protected void resetRuntimeRatios() {
        for (DistributionRatio runtimeRatio : this.runtimeRatios) {
            runtimeRatio.setRuntimeWeight(runtimeRatio.getDistributionWeight());
        }
    }

    public List<Integer> getDistributionRatioList() {
        return this.distributionRatioList;
    }

    public void setDistributionRatioList(List<Integer> distributionRatioList) {
        this.distributionRatioList = distributionRatioList;
    }

    public ArrayList<DistributionRatio> getRuntimeRatios() {
        return this.runtimeRatios;
    }

    public void setRuntimeRatios(ArrayList<DistributionRatio> runtimeRatios) {
        this.runtimeRatios = runtimeRatios;
    }
}

