package com.foc.service;

import com.foc.dao.BlackIpDao;
import com.foc.dao.SoundsMaxIdDao;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.io.Reader;
import java.util.List;

/**
 * @author zangtao
 * @create 2019 - 09 -25 18:10
 */
public class CheckBlackIpService {

    private static final Logger log = LoggerFactory.getLogger(CheckBlackIpService.class);

    private static Reader reader;

    private static SqlSessionFactory sqlSessionFactory;

    private static SqlSession session;

    public static void init() {
        try {
            reader = Resources.getResourceAsReader("mybatis-config.xml");
            sqlSessionFactory = new SqlSessionFactoryBuilder().build(reader);
            session = sqlSessionFactory.openSession();
        } catch (IOException e) {
            log.error("连接数据库异常");
            e.printStackTrace();
        }
    }


    public static void checkBlackIp() {
        //检查ip锁数据库
        BlackIpDao blackIpDao = session.getMapper(BlackIpDao.class);

        List<String> blackIpList = blackIpDao.getBlackIpList();
        if(!CollectionUtils.isEmpty(blackIpList)){
            blackIpList.forEach( (blackIp) ->{
                blackIpDao.deleteBlackIp(blackIp);
                log.info("删除的ip地址有:{}",blackIp);
            });
            session.commit();
        }

    }
}
