package com.foc.service;

import com.foc.util.PropertiesUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Properties;

/**
 * 发邮件
 *
 * @author zangtao
 * @create 2019 - 04 -11 16:25
 */
public class Email {

    private static final Logger logger = LoggerFactory.getLogger(Email.class);

    /**
     * 发送邮件
     *
     * @param toEmail 收件人邮箱
     * @param subject 主题
     * @param body 正文
     * @return
     */
    public static String sendEmail(String toEmail , String subject , String body ){

        //读取配置文件
        Properties properties = PropertiesUtils.getProperties();

        //接口地址
        String emailUrl = properties.getProperty("emailUrl");

        //邮件服务发件人参数
        String fromEmail = properties.getProperty("fromEmail");

        //发件人的内网账号
        String UserName = properties.getProperty("UserName");

        //发件人的密码
        String UserPwd = properties.getProperty("UserPwd");

        HttpClient httpClient = HttpClients.createDefault();

        try {
            HttpPost httpPost = new HttpPost("https://dsp.jdair.net/flightinterface/uss/json/email/sendEmail.json" + "?ai.cc=5&ai.cc=1&ai.cp=10.68.26.52"
                    + "&fromEmail=" + fromEmail + "&fromPasswd=" + UserPwd
            + "&toEmail=" + toEmail + "&subject=" + subject
                    + "&fromName=sdhkyxglzx" + "&content=" + body);
            HttpResponse response = httpClient.execute(httpPost);
            logger.info(response.toString());
            return response.getEntity().toString();
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        return null;

    }

    public static void main(String[] args) {

        System.out.println(sendEmail("906577196@qq.com","测试测试","你好啊啊啊啊啊"));

    }



}
