/**
 *
 */
package com.foc.task;

import java.util.List;

import com.foc.fetcher.HCFetcher;
import com.foc.util.DateUtil;
import com.uc.demo.UCDepartmentDemo;
import com.uc.entity.SeatEntity;
import com.uc.entity.UserProfileEntity;
import com.uc.service.UCUserService;

/**
 * 
 * @team IT Team
 * @author renmb
 * @version 1.0
 * @time  2017年1月17日
 */
public class UCUserTaskMain {

    /**
     * 
     * @author renmb
     * @time  2017年1月17日
     * @param args
     */
    public static void main(String[] args) {
        // TODO Auto-generated method stub
        System.out.println("[UCUserTaskMain]开始时间[" + DateUtil.getDateTime() + "]");
        long startTime = System.nanoTime();
        try {
            UCUserService service = new UCUserService();
            if(args.length>0){
                if("SQL".equals(args[0])){// 通过SQL同步
                    
                    if(args[1].startsWith("SELECT")){
                        List<UserProfileEntity> users = service.findUserListBySql(args[1]);
                        System.out.println("本次同步总人数："+users.size());
                        service.addAccountToUc(users);
                        
                        List<SeatEntity> seatList = service.findSeatListBySql(args[1]);// 同步指定用户ID的用户
                        System.out.println("本次同步总席位数："+seatList.size());
                        service.addSeatAccountToUc(seatList);
                    }
                } else if("ALL".equals(args[0])){// 同步所有没有绑定华为账号的用户
                    
                    List<UserProfileEntity> users = service.findUserList(null);
                    System.out.println("本次同步总人数："+users.size());
                    service.addAccountToUc(users);
                    
                    List<SeatEntity> seatList = service.findSeatList(null);// 同步指定用户ID的用户
                    System.out.println("本次同步总席位数："+seatList.size());
                    service.addSeatAccountToUc(seatList);
                } else {
                    
                    List<UserProfileEntity> users = service.findUserList(args);// 同步指定用户ID的用户
                    System.out.println("本次同步总人数："+users.size());
                    service.addAccountToUc(users);
                    
                    List<SeatEntity> seatList = service.findSeatList(args);// 同步指定用户ID的用户
                    System.out.println("本次同步总席位数："+seatList.size());
                    service.addSeatAccountToUc(seatList);
                }
            }
        } catch (Exception e) {
            // TODO: handle exception
        }
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        System.out.println("[UCUserTaskMain]结束时间[" + DateUtil.getDateTime() + "]");
        System.out.println("[UCUserTaskMain]总共用时：" + duration + "纳秒");
        System.out.println("[UCUserTaskMain]总共用时格式化：" + DateUtil.getDurationTime(duration));
        HCFetcher.getInstance().shutdown();
        System.exit(0);
    }

}
