package com.foc.conf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

import org.apache.log4j.Logger;

public class HistoryConfig {

    private static Logger log = Logger.getLogger(HistoryConfig.class);
    private static Properties props;
    private static InputStream input;
    private static OutputStream out;

    static {
        try {

            File config = new File("history.properties");
            if (!config.exists()) {
                config.createNewFile();
            }
            input = new BufferedInputStream(new FileInputStream(config));
            props = new Properties();
            props.load(input);
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            log.error("读取System.out.print(文件失败！！！");
        } catch (IOException e) {
            // TODO Auto-generated catch block
            log.error("解析history.properties文件失败！！！");
        } finally {

            try {
                if (input != null)
                    input.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                log.error("加载history.properties配置文件失败：\n\t" + e.getMessage());
            }
        }
    }

    public static void saveHistory() {

        try {

            out = new FileOutputStream(new File("history.properties"));
            props.store(out, "程序运行记录");
        } catch (FileNotFoundException e) {
            // TODO Auto-generated catch block
            log.error("建立history.properties输出流失败！！！\n\t" + e.getMessage());
        } catch (IOException e) {
            // TODO Auto-generated catch block
            log.error("保存history.properties文件失败！！！\n\t" + e.getMessage());
        } finally {

            if (out != null) {

                try {
                    out.close();
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    log.error("关闭history.properties文件失败！！！\n\t"
                            + e.getMessage());
                }
            }
        }
    }

    public static boolean containsKey(String key){
        return getValue(key)==null;
    }
    public static void put(String key, String value){
        
        props.put(key, value);
    }
    public static int getInt(String key, int want){
        
        return Integer.parseInt(getValue(key, String.valueOf(want)));
    }
    public static String getValue(String key, String want){
        return (props == null || props.getProperty(key)==null)?want:props.getProperty(key);
    }
    public static String getValue(String key){
        
        return getValue(key, null);
    }
    public static int getIntValue(String key, int want){
        
        return Integer.parseInt(getValue(key, String.valueOf(want)));
    }
    public static int getIntValue(String key){
        
        return Integer.parseInt(getValue(key, null));
    }
    
    public static long getLong(String key, long want){
        
        return Long.parseLong(getValue(key, String.valueOf(want)));
    }
    public static long getLong(String key){
        
        return Long.parseLong(getValue(key, null));
    }

    public static long getTimestamp(String key) {

        SimpleDateFormat sdf = null;
        String day = HistoryConfig.props.getProperty(key);
        if (day.trim().length() == "yyyy-MM-dd HH:mm:ss".length())
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        else if (day.trim().length() == "yyyy-MM-dd".length())
            sdf = new SimpleDateFormat("yyyy-MM-dd");
        else {
            log.error("日期格式不对！");
        }
        try {

            Date date = sdf.parse(day.trim());
            return date.getTime();
        } catch (ParseException e) {
            // TODO Auto-generated catch block
            log.error("解析日期错误：\n\t" + e.getMessage());
            return -1L;
        }
    }
}
