/**
 *
 */
package com.foc.task;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.foc.conf.GConstants;
import com.foc.sound.entity.SoundRecordingEntity;
import com.foc.util.DBHelper;
import com.huawei.esdk.uc.professional.local.utils.AES128Utils;

/**
 * 
 * @team BBDTEK IT Team
 * @author renmb
 * @version 1.0
 * @time  2017年9月3日
 */
public class SoundCopyTaskMain {

    /**
     * 
     * @author renmb
     * @time  2017年9月3日
     * @param args
     */
    public static void main(String[] args) {

        List<Map<String, Object>> sounds = new ArrayList<>();
        
        String driver = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
        String url = "jdbc:microsoft:sqlserver://10.72.23.187:1433;DatabaseName=edison200";
        Connection conn = null;
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        String username = GConstants.getValue("anke.database.username", "foctest");
        String password = GConstants.getValue("anke.database.password", "123@abc");
        username= AES128Utils.decryptPwd(username);
        password= AES128Utils.decryptPwd(password);
        try {
            Class.forName(driver);
            conn = DriverManager.getConnection(url, username, password);
            pstmt = conn
                    .prepareStatement("select * from dbo.cdr where id BETWEEN " + 10000 + " AND "+30000+" order by id ASC");
            rs = pstmt.executeQuery();
            List<SoundRecordingEntity> recordingEntities = new ArrayList<SoundRecordingEntity>();
            System.out.printf("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n","id","caller","callee","stm","edm","elapsed","recfile","filesize","callresult");
            while (rs.next()) {
                SoundRecordingEntity recordingEntity = new SoundRecordingEntity();
                recordingEntity.setId(String.valueOf(rs.getInt("id")));
                recordingEntity.setCallNo(rs.getString("caller"));
                recordingEntity.setAcceptNo(rs.getString("callee"));
                recordingEntity.setBeginTime(rs.getDate("stm"));
                recordingEntity.setEndTime(rs.getDate("edm"));
                recordingEntity.setDuration(rs.getInt("elapsed"));
                recordingEntity.setDownloadUrl(rs.getString("recfile"));
                recordingEntity.setDownloadSize(rs.getLong("filesize"));
                recordingEntity.setResult(rs.getString("callresult"));
                recordingEntities.add(recordingEntity);
                System.out.printf("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n",rs.getObject("id"),rs.getObject("caller"), rs.getObject("callee"), rs.getObject("stm"), rs.getObject("edm"), rs.getObject("elapsed"), rs.getObject("recfile"), rs.getObject("filesize"), rs.getObject("callresult"));
                Map<String, Object> row = new HashMap<>(10);
                row.put("id", rs.getObject("id"));
                row.put("caller", rs.getObject("caller"));
                row.put("callee", rs.getObject("callee"));
                row.put("stm", rs.getObject("stm"));
                row.put("edm", rs.getObject("edm"));
                row.put("elapsed", rs.getObject("elapsed"));
                row.put("recfile", rs.getObject("recfile"));
                row.put("filesize", rs.getObject("filesize"));
                row.put("direct", rs.getObject("direct"));
                row.put("callresult", rs.getObject("callresult"));
                
                sounds.add(row);
            }
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            try {
                rs.close();
            } catch (Exception e2) {}
            try {
                pstmt.close();
            } catch (Exception e2) {}
            try {
                conn.close();
            } catch (Exception e2) {}
        }
        DBHelper.insert("foc", "dbo.cdr", sounds);
    }

}
