/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver.tds;

import com.microsoft.jdbc.base.BaseWarnings;
import com.microsoft.jdbc.sqlserver.tds.TDSConnection;
import com.microsoft.jdbc.sqlserver.tds.TDSRequest;
import com.microsoft.util.UtilByteArray;
import com.microsoft.util.UtilByteOrderedDataReader;
import com.microsoft.util.UtilByteOrderedDataWriter;
import com.microsoft.util.UtilException;
import java.sql.SQLException;

public class TDSLoginRequest
extends TDSRequest {
    private static String footprint = "$Revision:   1.32.1.2  $";
    private String username;
    private String password;
    private String databaseName;
    private String programName;
    private String hostProcess;
    private String netAddress;
    private String WSID;
    private static int TDS_LOGIN_REQUEST_BASE_LEN = 86;
    private static int ORDER_X86 = 0;
    private static int ORDER_68000 = 1;
    private static int CHARSET_ASCII = 0;
    private static int CHARSET_EBCDIC = 1;
    private static int FLOAT_IEEE_754 = 0;
    private static int FLOAT_VAX = 1;
    private static int FLOAT_ND5000 = 2;
    private static int DUMPLOAD_OFF = 0;
    private static int DUMPLOAD_ON = 1;
    private static int USE_DB_OFF = 0;
    private static int USE_DB_ON = 1;
    private static int INIT_DB_WARN = 0;
    private static int INIT_DB_FATAL = 1;
    private static int SET_LANG_OFF = 0;
    private static int SET_LANG_ON = 1;
    private static int INIT_LANG_WARN = 0;
    private static int INIT_LANG_FATAL = 1;
    private static int ODBC_OFF = 0;
    private static int ODBC_ON = 1;
    private static int TRAN_BOUNDARY_OFF = 0;
    private static int TRAN_BOUNDARY_ON = 1;
    private static int CACHE_CONNECTION_OFF = 0;
    private static int CACHE_CONNECTION_ON = 1;
    private static int USER_NORMAL = 0;
    private static int USER_SERVER = 1;
    private static int USER_REMUSER = 2;
    private static int USER_SQLREPL = 3;
    private static int INTEGRATED_SECURITY_OFF = 0;
    private static int INTEGRATED_SECURITY_ON = 1;
    private static int SQL_DFLT = 0;
    private static int SQL_TSQL = 1;
    private static int SQL_ANSI_V1 = 2;
    private static int SQL_ANSI89_L1 = 3;
    private static int SQL_ANSI89_L2 = 4;
    private static int SQL_ANSI89_IEF = 5;
    private static int SQL_ANSI92_ENTRY = 6;
    private static int SQL_ANSI92_TRANS = 7;
    private static int SQL_ANSI92_INTER = 8;
    private static int SQL_ANSI92_FULL = 9;
    private static int MAXNICSIZE = 6;

    public TDSLoginRequest(TDSConnection tDSConnection, UtilByteOrderedDataReader utilByteOrderedDataReader, UtilByteOrderedDataWriter utilByteOrderedDataWriter, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        super(tDSConnection, utilByteOrderedDataReader, utilByteOrderedDataWriter, 16);
        this.username = string;
        this.password = string2;
        this.databaseName = string3;
        this.programName = string4;
        this.hostProcess = string5;
        this.netAddress = string6;
        this.WSID = string7;
    }

    private byte[] encodeNetAddress() {
        byte[] byArray = new byte[6];
        boolean bl = false;
        if (this.netAddress.length() == MAXNICSIZE * 2) {
            try {
                int n = 0;
                while (n < MAXNICSIZE) {
                    int n2 = Integer.parseInt(this.netAddress.substring(n * 2, n * 2 + 2), 16);
                    if (n2 < 0) break;
                    byArray[n] = (byte)n2;
                    ++n;
                }
                bl = true;
            }
            catch (Exception exception) {}
        }
        if (!bl) {
            UtilByteArray.fill((byte[])byArray, (int)0);
        }
        return byArray;
    }

    private static byte[] encryptPassword(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            byte by = (byte)c;
            byArray[n2 * 2] = (byte)((by << 4 | by >> 4) ^ 0xA5);
            by = (byte)(c >> 8);
            byArray[n2 * 2 + 1] = (byte)((by << 4 | by >> 4) ^ 0xA5);
            ++n2;
        }
        return byArray;
    }

    public boolean processReplyToken(byte by, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (by) {
                case -3: {
                    int n = this.reader.readUnsignedInt16();
                    int n2 = this.reader.readUnsignedInt16();
                    int n3 = this.reader.readInt32();
                    if ((n & 2) == 0) break;
                    this.exception = this.conn.exceptions.getException(this.exception, 1, 11004, "08001");
                    break;
                }
                case -83: {
                    int n = this.reader.readUnsignedInt16();
                    byte by2 = this.reader.readInt8();
                    this.reader.setToBigEndian();
                    this.conn.setTDSVersion(this.reader.readInt32());
                    this.reader.setToLittleEndian();
                    String string = this.reader.readString(this.reader.readInt8() * 2);
                    String string2 = String.valueOf(this.reader.readInt8()) + "." + this.reader.readInt8() + ".";
                    this.reader.setToBigEndian();
                    string2 = String.valueOf(string2) + this.reader.readInt16();
                    this.reader.setToLittleEndian();
                    break;
                }
                default: {
                    super.processReplyToken(by, baseWarnings);
                }
            }
            return true;
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void submitRequest() throws SQLException {
        int n = 0;
        try {
            String string = null;
            string = this.WSID.length() == 0 ? this.conn.getLocalHostname() : this.WSID;
            byte[] byArray = this.conn.unicodeTransliterator.encode(string);
            byte[] byArray2 = this.conn.unicodeTransliterator.encode(this.username);
            byte[] byArray3 = TDSLoginRequest.encryptPassword(this.password);
            int n2 = byArray3 == null ? 0 : byArray3.length;
            byte[] byArray4 = this.conn.unicodeTransliterator.encode(this.programName);
            String string2 = this.conn.getServerHostname();
            byte[] byArray5 = this.conn.unicodeTransliterator.encode(string2);
            byte[] byArray6 = this.conn.unicodeTransliterator.encode(this.databaseName);
            int n3 = TDS_LOGIN_REQUEST_BASE_LEN + byArray.length + byArray2.length + n2 + byArray4.length + byArray5.length + byArray6.length;
            this.clearReplyChannel();
            TDSConnection tDSConnection = this.conn;
            synchronized (tDSConnection) {
                this.conn.setMessageType(this.messageType);
                this.writer.writeInt32(n3);
                this.writer.writeInt32(0x71000000);
                this.writer.writeInt32(0);
                this.writer.writeInt32(0);
                try {
                    this.writer.writeInt32(Integer.decode(this.hostProcess).intValue());
                }
                catch (NumberFormatException numberFormatException) {
                    this.writer.writeInt32(0);
                }
                this.writer.writeInt32(0);
                this.writer.writeInt8(224);
                this.writer.writeInt8(3);
                this.writer.writeInt8(SQL_DFLT << 4);
                this.writer.writeInt8(0);
                this.writer.writeInt32(0);
                this.writer.writeInt32(0);
                this.writer.writeInt16(TDS_LOGIN_REQUEST_BASE_LEN);
                this.writer.writeInt16(string.length());
                this.writer.writeInt16(TDS_LOGIN_REQUEST_BASE_LEN + (n += byArray.length));
                this.writer.writeInt16(this.username.length());
                this.writer.writeInt16(TDS_LOGIN_REQUEST_BASE_LEN + (n += byArray2.length));
                this.writer.writeInt16(this.password.length());
                this.writer.writeInt16(TDS_LOGIN_REQUEST_BASE_LEN + (n += n2));
                this.writer.writeInt16(this.programName.length());
                this.writer.writeInt16(TDS_LOGIN_REQUEST_BASE_LEN + (n += byArray4.length));
                this.writer.writeInt16(string2.length());
                n += byArray5.length;
                this.writer.writeInt16(0);
                this.writer.writeInt16(0);
                this.writer.writeInt16(0);
                this.writer.writeInt16(0);
                this.writer.writeInt16(0);
                this.writer.writeInt16(0);
                this.writer.writeInt16(TDS_LOGIN_REQUEST_BASE_LEN + n);
                this.writer.writeInt16(this.databaseName.length());
                n += byArray6.length;
                this.writer.writeBytes(this.encodeNetAddress());
                this.writer.writeInt16(0);
                this.writer.writeInt16(0);
                this.writer.writeInt16(0);
                this.writer.writeInt16(0);
                this.writer.writeBytes(byArray);
                this.writer.writeBytes(byArray2);
                this.writer.writeBytes(byArray3);
                this.writer.writeBytes(byArray4);
                this.writer.writeBytes(byArray5);
                this.writer.writeBytes(byArray6);
                this.writer.send();
            }
            this.reader.receive();
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }
}

