/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.esdk.uc.professional.local.resource;

import com.google.gson.Gson;
import com.huawei.esdk.uc.professional.local.bean.RestRequestMessage;
import com.huawei.esdk.uc.professional.local.bean.south.QueryEnterpriseRequest;
import com.huawei.esdk.uc.professional.local.bean.south.QueryEnterpriseResponse;
import com.huawei.esdk.uc.professional.local.bean.south.QueryPersonInfoResponse;
import com.huawei.esdk.uc.professional.local.utils.PropertiesUtils;
import com.huawei.esdk.uc.professional.local.utils.RestUtils;
import com.huawei.esdk.uc.professional.local.utils.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class UserProfileCorpList {
    private static final Logger LOGGER = Logger.getLogger(UserProfileCorpList.class);
    private static final Gson GSON = new Gson();

    public QueryEnterpriseResponse queryEnterprise(QueryEnterpriseRequest request) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("departmentId", request.getDepartmentId());
        parameters.put("pageCount", request.getPageCount());
        parameters.put("pageNum", request.getPageNum());
        QueryEnterpriseResponse result = new QueryEnterpriseResponse();
        RestRequestMessage restRequestMessage = new RestRequestMessage();
        restRequestMessage.setHttpMethod("GET");
        restRequestMessage.setParameters(parameters);
        try {
            String responsePayload = RestUtils.getInstance().sendMessage(restRequestMessage, PropertiesUtils.getValue("enterprise.path"));
            if (!StringUtils.isEmpty(responsePayload)) {
                if ("401".equals(responsePayload)) {
                    result.setResultCode("401");
                } else {
                    result = (QueryEnterpriseResponse)GSON.fromJson(responsePayload, QueryEnterpriseResponse.class);
                    result.getEnterpriseList().setDeptId(request.getDepartmentId());
                }
            } else {
                result.setResultCode("1");
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("queryEnterprise error" + e));
        }
        catch (Exception e) {
            LOGGER.error((Object)("queryEnterprise error" + e));
        }
        return result;
    }

    public QueryPersonInfoResponse queryPersonInfo(String staffAccount) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("staffAccount", staffAccount);
        QueryPersonInfoResponse result = new QueryPersonInfoResponse();
        RestRequestMessage restRequestMessage = new RestRequestMessage();
        restRequestMessage.setHttpMethod("GET");
        restRequestMessage.setParameters(parameters);
        try {
            String responsePayload = RestUtils.getInstance().sendMessage(restRequestMessage, PropertiesUtils.getValue("person.path"));
            if (!StringUtils.isEmpty(responsePayload)) {
                if ("401".equals(responsePayload)) {
                    result.setResultCode("401");
                } else {
                    result = (QueryPersonInfoResponse)GSON.fromJson(responsePayload, QueryPersonInfoResponse.class);
                }
            } else {
                result.setResultCode(String.valueOf(1));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("queryPersonInfo error" + e));
        }
        catch (Exception e) {
            LOGGER.error((Object)("queryPersonInfo error" + e));
        }
        return result;
    }
}

