/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.esdk.uc.professional.local.resource;

import com.google.gson.Gson;
import com.huawei.esdk.uc.professional.local.bean.RestRequestMessage;
import com.huawei.esdk.uc.professional.local.bean.RestResponse;
import com.huawei.esdk.uc.professional.local.bean.south.AddAccountRequest;
import com.huawei.esdk.uc.professional.local.bean.south.ResHeaderBean;
import com.huawei.esdk.uc.professional.local.utils.PropertiesUtils;
import com.huawei.esdk.uc.professional.local.utils.RestUtils;
import com.huawei.esdk.uc.professional.local.utils.StringUtils;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AccountResource {
    private static final Logger LOGGER = Logger.getLogger(AccountResource.class);
    private static final Gson GSON = new Gson();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RestResponse<String> addAccount(AddAccountRequest acct) {
        RestResponse<String> result = null;
        RestRequestMessage restRequestMessage = new RestRequestMessage();
        restRequestMessage.setHttpMethod("POST");
        restRequestMessage.setPayload(acct);
        try {
            String responsePayload = RestUtils.getInstance().sendMessage(restRequestMessage, PropertiesUtils.getValue("account.path"));
            if (!StringUtils.isEmpty(responsePayload)) {
                if (!"401".equals(responsePayload)) return (RestResponse)GSON.fromJson(responsePayload, RestResponse.class);
                result = new RestResponse();
                result.setResultCode("401");
            } else {
                result = new RestResponse<String>();
                result.setResultCode(String.valueOf(1));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("addDepartment error" + e));
        }
        catch (Exception e) {
            LOGGER.error((Object)("addDepartment error" + e));
        }
        result = new RestResponse();
        result.setResultCode(String.valueOf(1));
        return result;
    }

    public ResHeaderBean modifyAcountPassword(AddAccountRequest acct) {
        ResHeaderBean result = null;
        RestRequestMessage restRequestMessage = new RestRequestMessage();
        restRequestMessage.setHttpMethod("PUT");
        restRequestMessage.setPayload(acct);
        try {
            String responsePayload = RestUtils.getInstance().sendMessage(restRequestMessage, PropertiesUtils.getValue("modify_account_password.path"));
            if (!StringUtils.isEmpty(responsePayload)) {
                if ("401".equals(responsePayload)) {
                    result = new ResHeaderBean();
                    result.setResultCode("401");
                    return result;
                }
                return (ResHeaderBean)GSON.fromJson(responsePayload, ResHeaderBean.class);
            }
            result = new ResHeaderBean();
            result.setResultCode(String.valueOf(1));
        }
        catch (IOException e) {
            LOGGER.error((Object)("modifyAcountPassword error" + e));
        }
        catch (Exception e) {
            LOGGER.error((Object)("modifyAcountPassword error" + e));
        }
        result = new ResHeaderBean();
        result.setResultCode(String.valueOf(1));
        return result;
    }
}

