/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.vendor;

import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.ValidConnectionChecker;
import com.alibaba.druid.pool.ValidConnectionCheckerAdapter;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.Utils;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class MySqlValidConnectionChecker
extends ValidConnectionCheckerAdapter
implements ValidConnectionChecker,
Serializable {
    public static final int DEFAULT_VALIDATION_QUERY_TIMEOUT = 1000;
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(MySqlValidConnectionChecker.class);
    private Class<?> clazz;
    private Method ping;
    private boolean usePingMethod = false;

    public MySqlValidConnectionChecker() {
        try {
            this.clazz = Utils.loadClass("com.mysql.jdbc.MySQLConnection");
            this.ping = this.clazz.getMethod("pingInternal", Boolean.TYPE, Integer.TYPE);
            if (this.ping != null) {
                this.usePingMethod = true;
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot resolve com.mysq.jdbc.Connection.ping method.  Will use 'SELECT 1' instead.", e);
        }
        this.configFromProperties(System.getProperties());
    }

    @Override
    public void configFromProperties(Properties properties) {
        String property = properties.getProperty("druid.mysql.usePingMethod");
        if ("true".equals(property)) {
            this.setUsePingMethod(true);
        } else if ("false".equals(property)) {
            this.setUsePingMethod(false);
        }
    }

    public boolean isUsePingMethod() {
        return this.usePingMethod;
    }

    public void setUsePingMethod(boolean usePingMethod) {
        this.usePingMethod = usePingMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isValidConnection(Connection conn, String validateQuery, int validationQueryTimeout) {
        boolean bl;
        try {
            if (conn.isClosed()) {
                return false;
            }
        }
        catch (SQLException ex) {
            return false;
        }
        if (this.usePingMethod) {
            if (conn instanceof DruidPooledConnection) {
                conn = ((DruidPooledConnection)conn).getConnection();
            }
            if (conn instanceof ConnectionProxy) {
                conn = ((ConnectionProxy)conn).getRawObject();
            }
            if (this.clazz.isAssignableFrom(conn.getClass())) {
                if (validationQueryTimeout < 0) {
                    validationQueryTimeout = 1000;
                }
                try {
                    this.ping.invoke((Object)conn, true, validationQueryTimeout);
                    return true;
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof SQLException) {
                        return false;
                    }
                    LOG.warn("Unexpected error in ping", e);
                    return false;
                }
                catch (Exception e) {
                    LOG.warn("Unexpected error in ping", e);
                    return false;
                }
            }
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            if (validationQueryTimeout > 0) {
                stmt.setQueryTimeout(validationQueryTimeout);
            }
            rs = stmt.executeQuery(validateQuery);
            bl = true;
            JdbcUtils.close(rs);
        }
        catch (SQLException e) {
            boolean bl2 = false;
            return bl2;
        }
        catch (Exception e2) {
            LOG.warn("Unexpected error in ping", e2);
            boolean bl3 = false;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            return bl3;
        }
        finally {
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
        }
        JdbcUtils.close(stmt);
        return bl;
    }
}

