/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.esdk.uc.professional.local.utils;

import com.google.gson.Gson;
import com.huawei.esdk.uc.professional.local.bean.RestRequestMessage;
import com.huawei.esdk.uc.professional.local.bean.platform.GetPublicKeyResponse;
import com.huawei.esdk.uc.professional.local.bean.platform.SetSecretKeyResponse;
import com.huawei.esdk.uc.professional.local.bean.south.RestRequestSecret;
import com.huawei.esdk.uc.professional.local.utils.AES128Utils;
import com.huawei.esdk.uc.professional.local.utils.Base64Utils;
import com.huawei.esdk.uc.professional.local.utils.PropertiesUtils;
import com.huawei.esdk.uc.professional.local.utils.RSA2048Utils;
import com.huawei.esdk.uc.professional.local.utils.RestUtils;
import com.huawei.esdk.uc.professional.local.utils.StringUtils;
import java.io.IOException;
import org.apache.log4j.Logger;

public class KeyManagerUtils {
    private static final Logger LOGGER = Logger.getLogger(KeyManagerUtils.class);
    private static final Gson GSON = new Gson();

    public static int initTransmissionMode() {
        String transmissionMode = PropertiesUtils.getValue("sensitive.information.transmission.mode");
        if ("AES128_consulted".equals(transmissionMode)) {
            return KeyManagerUtils.setSecretkey() ? 0 : 2130000044;
        }
        if ("RSA2048".equals(transmissionMode)) {
            return KeyManagerUtils.getPublicKey() ? 0 : 2130000037;
        }
        return 0;
    }

    public static boolean getPublicKey() {
        GetPublicKeyResponse result = null;
        RestRequestMessage restRequestMessage = new RestRequestMessage();
        restRequestMessage.setHttpMethod("GET");
        String responsePayload = null;
        try {
            responsePayload = RestUtils.getInstance().sendMessage(restRequestMessage, PropertiesUtils.getValue("publicKey.path"));
            if (!StringUtils.isEmpty(responsePayload) && !"401".equals(responsePayload)) {
                result = (GetPublicKeyResponse)GSON.fromJson(responsePayload, GetPublicKeyResponse.class);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("get public key error" + e));
        }
        catch (Exception e) {
            LOGGER.error((Object)("get public key error" + e));
        }
        if (result != null && "0".equals(result.getHeader().getResultCode())) {
            RSA2048Utils.setPublicKey(result.getPublicKey());
            return true;
        }
        return false;
    }

    public static boolean setSecretkey() {
        String secretType = "AES128";
        String secretKeyString = KeyManagerUtils.byte2Hex(AES128Utils.getBT_KEY());
        String ivString = KeyManagerUtils.byte2Hex(AES128Utils.getBT_IV());
        if (!KeyManagerUtils.getPublicKey()) {
            LOGGER.error((Object)"getPublicKey failed");
            return false;
        }
        String secretKeyCode = null;
        String ivCode = null;
        try {
            secretKeyCode = Base64Utils.encode(RSA2048Utils.encode(secretKeyString.getBytes("UTF-8")));
            ivCode = Base64Utils.encode(RSA2048Utils.encode(ivString.getBytes("UTF-8")));
        }
        catch (Exception e) {
            LOGGER.error((Object)("password encrypt failed" + e));
        }
        RestRequestSecret restRequestSecret = new RestRequestSecret();
        restRequestSecret.setSecretType(secretType);
        restRequestSecret.setSecretKey(secretKeyCode);
        restRequestSecret.setIv(ivCode);
        RestRequestMessage restRequestMessage = new RestRequestMessage();
        restRequestMessage.setHttpMethod("POST");
        restRequestMessage.setPayload(restRequestSecret);
        SetSecretKeyResponse result = null;
        try {
            String responsePayload = RestUtils.getInstance().sendMessage(restRequestMessage, PropertiesUtils.getValue("secretkey.path"));
            if (!StringUtils.isEmpty(responsePayload) && !"401".equals(responsePayload)) {
                result = (SetSecretKeyResponse)GSON.fromJson(responsePayload, SetSecretKeyResponse.class);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("set secret key error" + e));
        }
        catch (Exception e) {
            LOGGER.error((Object)("set secret key error" + e));
        }
        return result != null && "0".equals(result.getResultCode());
    }

    public static String byte2Hex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString();
    }
}

