/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.esdk.uc.professional.local.utils;

import com.huawei.esdk.uc.professional.local.utils.Base64Utils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public final class AESCbc128Utils {
    private static final Logger LOGGER = Logger.getLogger(AESCbc128Utils.class);
    private static final int AES_128_KEY_LEN = 16;
    private static final byte[] BT_KEY = AESCbc128Utils.getBytes("PASSWORD@ESDKNATIVE12");
    private static final byte[] BT_IV = AESCbc128Utils.getBytes("INITIAL@NATIVE12");

    public static byte[] getBytes(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] encode(byte[] btPlain) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return AESCbc128Utils.encodeDecode(btPlain, BT_KEY, BT_IV, 0);
    }

    public static byte[] encode(byte[] btPlain, byte[] btKey, byte[] btIV) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return AESCbc128Utils.encodeDecode(btPlain, btKey, btIV, 0);
    }

    public static byte[] decode(byte[] btCipher) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return AESCbc128Utils.encodeDecode(btCipher, BT_KEY, BT_IV, 1);
    }

    public static byte[] decode(byte[] btCipher, byte[] btKey, byte[] btIV) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return AESCbc128Utils.encodeDecode(btCipher, btKey, btIV, 1);
    }

    public static void testAes128() throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException {
        String str = "nihao";
        byte[] btData = str.getBytes();
        byte[] dtData = AESCbc128Utils.encodeDecode(btData, BT_KEY, BT_IV, 0);
        byte[] bData = AESCbc128Utils.encodeDecode(dtData, BT_KEY, BT_IV, 1);
        System.out.println(new String(bData));
    }

    public static byte[] encodeDecode(byte[] btData, byte[] btKey, byte[] btIV, int iFlag) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        int iIVLen;
        byte[] l_btKey = null;
        Cipher l_oCipher = null;
        if (btData == null || btKey == null) {
            return null;
        }
        int iLen = btData.length;
        int iKeyLen = btKey.length;
        int n = iIVLen = btIV == null ? 0 : btIV.length;
        if (iKeyLen > 16) {
            iKeyLen = 16;
        }
        l_btKey = new byte[16];
        int ii = 0;
        while (ii < 16) {
            l_btKey[ii] = 0;
            ++ii;
        }
        ii = 0;
        while (ii < iKeyLen) {
            l_btKey[ii] = btKey[ii];
            ++ii;
        }
        l_oCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        int l_iMode = iFlag == 0 ? 1 : 2;
        if (btIV == null) {
            l_oCipher.init(l_iMode, new SecretKeySpec(l_btKey, 0, 16, "AES"));
        } else {
            l_oCipher.init(l_iMode, (Key)new SecretKeySpec(l_btKey, 0, 16, "AES"), new IvParameterSpec(btIV, 0, iIVLen));
        }
        l_btKey = null;
        return l_oCipher.doFinal(btData, 0, iLen);
    }

    public static String decryptPwd(String userId, String pwd) {
        try {
            byte[] temp = Base64Utils.getFromBASE64(pwd);
            if (temp == null || temp.length == 0) {
                return pwd;
            }
            String result = new String(AESCbc128Utils.decode(temp), "UTF-8");
            if (result.startsWith(userId) && !result.equals(userId)) {
                result = result.substring(userId.length());
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Decrypt password error[userId=]" + userId));
            return pwd;
        }
    }

    public static String decodeFromBase64(String password) {
        try {
            return new String(AESCbc128Utils.decode(Base64Utils.getFromBASE64(password)));
        }
        catch (Exception e) {
            LOGGER.error((Object)"password decode error", (Throwable)e);
            return "";
        }
    }
}

