/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.esdk.uc.professional.local.utils;

import com.huawei.esdk.uc.professional.local.utils.Base64Utils;
import com.huawei.esdk.uc.professional.local.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public final class AES128Utils {
    private static final Logger LOGGER = Logger.getLogger(AES128Utils.class);
    private static final int AES_128_KEY_LEN = 16;
    public static final String KEY_ALGORITHM = "AES";
    private static String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static byte[] BT_KEY = SecureRandom.getSeed(16);
    private static byte[] BT_IV = SecureRandom.getSeed(16);

    public static byte[] getBytes(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public static byte[] encode(byte[] btPlain) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return AES128Utils.encodeDecode(btPlain, BT_KEY, BT_IV, 0);
    }

    public static byte[] encode(byte[] btPlain, byte[] btKey, byte[] btIV) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return AES128Utils.encodeDecode(btPlain, btKey, btIV, 0);
    }

    public static byte[] decode(byte[] btCipher) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return AES128Utils.encodeDecode(btCipher, BT_KEY, BT_IV, 1);
    }

    public static byte[] decode(byte[] btCipher, byte[] btKey, byte[] btIV) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return AES128Utils.encodeDecode(btCipher, btKey, btIV, 1);
    }

    public static byte[] encodeDecode(byte[] btData, byte[] btKey, byte[] btIV, int iFlag) throws BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        int iIVLen;
        byte[] l_btKey = null;
        Cipher l_oCipher = null;
        if (btData == null || btKey == null) {
            return new byte[0];
        }
        int iLen = btData.length;
        int iKeyLen = btKey.length;
        int n = iIVLen = btIV == null ? 0 : btIV.length;
        if (iKeyLen > 16) {
            iKeyLen = 16;
        }
        l_btKey = new byte[16];
        int ii = 0;
        while (ii < 16) {
            l_btKey[ii] = 0;
            ++ii;
        }
        ii = 0;
        while (ii < iKeyLen) {
            l_btKey[ii] = btKey[ii];
            ++ii;
        }
        l_oCipher = Cipher.getInstance(CIPHER_ALGORITHM);
        int l_iMode = iFlag == 0 ? 1 : 2;
        if (btIV == null) {
            l_oCipher.init(l_iMode, new SecretKeySpec(l_btKey, 0, 16, KEY_ALGORITHM));
        } else {
            l_oCipher.init(l_iMode, (Key)new SecretKeySpec(l_btKey, 0, 16, KEY_ALGORITHM), new IvParameterSpec(btIV, 0, iIVLen));
        }
        return l_oCipher.doFinal(btData, 0, iLen);
    }

    public static String encryptPwd(String plainPwd) {
        try {
            return Base64Utils.encode(AES128Utils.encode(AES128Utils.getBytes(plainPwd)));
        }
        catch (InvalidKeyException e) {
            LOGGER.error((Object)"Encrypt password error", (Throwable)e);
            return plainPwd;
        }
        catch (BadPaddingException e) {
            LOGGER.error((Object)"Encrypt password error", (Throwable)e);
            return plainPwd;
        }
        catch (IllegalBlockSizeException e) {
            LOGGER.error((Object)"Encrypt password error", (Throwable)e);
            return plainPwd;
        }
        catch (InvalidAlgorithmParameterException e) {
            LOGGER.error((Object)"Encrypt password error", (Throwable)e);
            return plainPwd;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"Encrypt password error", (Throwable)e);
            return plainPwd;
        }
        catch (NoSuchPaddingException e) {
            LOGGER.error((Object)"Encrypt password error", (Throwable)e);
            return plainPwd;
        }
    }

    public static String decryptPwd(String pwd) {
        if (StringUtils.isEmpty(pwd)) {
            return "";
        }
        try {
            byte[] temp = Base64Utils.getFromBASE64(pwd);
            if (temp.length == 0) {
                return pwd;
            }
            String result = new String(AES128Utils.decode(temp), "UTF-8");
            return result;
        }
        catch (InvalidKeyException e) {
            LOGGER.error((Object)"Decrypt password error", (Throwable)e);
            return pwd;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"Decrypt password error", (Throwable)e);
            return pwd;
        }
        catch (BadPaddingException e) {
            LOGGER.error((Object)"Decrypt password error", (Throwable)e);
            return pwd;
        }
        catch (IllegalBlockSizeException e) {
            LOGGER.error((Object)"Decrypt password error", (Throwable)e);
            return pwd;
        }
        catch (InvalidAlgorithmParameterException e) {
            LOGGER.error((Object)"Decrypt password error", (Throwable)e);
            return pwd;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"Decrypt password error", (Throwable)e);
            return pwd;
        }
        catch (NoSuchPaddingException e) {
            LOGGER.error((Object)"Decrypt password error", (Throwable)e);
            return pwd;
        }
    }

    public static String byte2Hex(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < buf.length) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString();
    }

    public static byte[] hex2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return new byte[0];
        }
        byte[] result = new byte[hexStr.length() / 2];
        int i = 0;
        while (i < hexStr.length() / 2) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
            ++i;
        }
        return result;
    }

    public static byte[] getBT_KEY() {
        if (BT_KEY == null) {
            return new byte[0];
        }
        return (byte[])BT_KEY.clone();
    }

    public static void setBT_KEY(byte[] bT_KEY) {
        if (bT_KEY != null) {
            BT_KEY = (byte[])bT_KEY.clone();
        }
    }

    public static byte[] getBT_IV() {
        if (BT_IV == null) {
            return new byte[0];
        }
        return (byte[])BT_IV.clone();
    }

    public static void setBT_IV(byte[] bT_IV) {
        if (bT_IV != null) {
            BT_IV = (byte[])bT_IV.clone();
        }
    }
}

